/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.io.Printable;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.StringUtils;

public class CaisseMenuPanel
extends JPanel {
    private CaisseFrame frame;

    CaisseMenuPanel(final CaisseFrame caisseFrame) {
        this.frame = caisseFrame;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(20, 20, 30, 20);
        JImage image = new JImage(ComptaBasePropsConfiguration.class.getResource("logo.png"));
        this.add((Component)image, c);
        ++c.gridx;
        File testTicketDir = new File("test");
        if (testTicketDir.exists() && testTicketDir.isDirectory()) {
            File[] files = testTicketDir.listFiles();
            int i = 0;
            while (i < files.length) {
                final File f = files[i];
                if (f.getName().endsWith(".txt")) {
                    POSButton b = new POSButton(f.getName().substring(0, f.getName().length() - 4));
                    this.add((Component)b, c);
                    ++c.gridy;
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            System.err.println("CaisseMenuPanel.CaisseMenuPanel(...).new ActionListener() {...}.actionPerformed()");
                            caisseFrame.getPOSConf().printOnceOnFirstPrinter(new Printable(){

                                @Override
                                public void print(TicketPrinter prt, int ticketWidth) {
                                    prt.clearBuffer(f.getName());
                                    System.err.println("CaisseMenuPanel.CaisseMenuPanel(...)print()");
                                    String content = f.getName();
                                    try {
                                        content = FileUtils.read(f);
                                        List<String> lines = StringUtils.splitIntoLines(content);
                                        for (String line : lines) {
                                            line = line.trim();
                                            System.err.println("CaisseMenuPanel.CaisseMenuPanel(...)print()" + line);
                                            if (line.startsWith("[bl]")) {
                                                prt.addToBuffer(line.substring(3), 2);
                                                continue;
                                            }
                                            if (line.startsWith("[b]")) {
                                                prt.addToBuffer(line.substring(3), 1);
                                                continue;
                                            }
                                            prt.addToBuffer(line);
                                        }
                                    }
                                    catch (IOException e1) {
                                        prt.addToBuffer(content);
                                        prt.addToBuffer(e1.getMessage());
                                        e1.printStackTrace();
                                    }
                                    try {
                                        prt.printBuffer();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                    });
                }
                ++i;
            }
        }
        POSButton bTickets = new POSButton("Liste des tickets");
        this.add((Component)bTickets, c);
        ++c.gridy;
        POSButton bCloture = new POSButton("Cl\u00f4turer");
        this.add((Component)bCloture, c);
        ++c.gridy;
        c.insets = new Insets(20, 20, 20, 20);
        c.fill = 0;
        c.anchor = 13;
        POSButton bQuit = new POSButton("Quitter");
        bQuit.setBackground(Color.decode("#AD1457"));
        this.add((Component)bQuit, c);
        bTickets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CaisseMenuPanel.this.frame.showTickets(null);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Erreur", ex);
                }
            }
        });
        bCloture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JPanel p = new JPanel();
                p.setOpaque(true);
                p.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.anchor = 17;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(20, 20, 30, 20);
                c.gridwidth = 2;
                p.add((Component)new POSLabel("Voulez vous cl\u00f4turer la caisse ?"), c);
                ++c.gridy;
                c.gridwidth = 1;
                POSButton bOkCloture = new POSButton("Cl\u00f4turer");
                bOkCloture.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            boolean quit = caisseFrame.getDB().fetchRegisterState().checkIfMoved(caisseFrame.getConf().getERP_TM());
                            if (!quit) {
                                CaisseMenuPanel.this.frame.getControler().setLCD("Cloture", "En cours...", 0);
                                int userID = caisseFrame.getPOSConf().getUserID();
                                RegisterLog newLog = caisseFrame.getFiles().close(userID);
                                caisseFrame.getDB().close(caisseFrame.getPOSConf(), newLog);
                                CaisseMenuPanel.this.frame.getControler().setLCD("Cloture", "Terminee", 0);
                            }
                            CaisseMenuPanel.this.quit();
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle("Erreur", ex);
                        }
                        System.err.println("CLOTURE");
                        CaisseMenuPanel.this.frame.showCaisse();
                    }
                });
                p.add((Component)bOkCloture, c);
                ++c.gridx;
                POSButton bCancelCloture = new POSButton("Annuler");
                bCancelCloture.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        p.setVisible(false);
                        System.err.println("CANCEL CLOTURE");
                        CaisseMenuPanel.this.frame.showCaisse();
                    }
                });
                p.add((Component)bCancelCloture, c);
                CaisseMenuPanel.this.frame.showPanel(p);
            }
        });
        bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CaisseMenuPanel.this.quit();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Erreur", ex);
                }
            }
        });
    }

    private void quit() {
        this.frame.dispose();
    }
}

