/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.RegisterLogEntry;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;

public class RegisterLog {
    private static final int VERSION = 2;
    private static final String VERSION_ATTR_NAME = "version";
    private final Path logFile;
    private Document parsed;
    private int version;
    private RegisterLogEntry.RegisterEntry opening;

    static final Element createRootElement() {
        return new Element("registerLog").setAttribute(VERSION_ATTR_NAME, String.valueOf(2));
    }

    public RegisterLog(Path logFile) {
        this.logFile = logFile;
    }

    public final Path getLogFile() {
        return this.logFile;
    }

    public final RegisterLog parse() throws IOException, JDOMException {
        RegisterLogEntry firstEntry;
        Document doc = RegisterFiles.parse(this.logFile);
        List<Element> elems = doc.getRootElement().getChildren();
        if (elems.isEmpty()) {
            throw new IllegalStateException("Empty log");
        }
        try {
            firstEntry = RegisterLogEntry.parseEntry(elems.get(0));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        if (firstEntry.getType() != EventType.REGISTER_OPENING) {
            throw new IllegalStateException("Do not begin with " + (Object)((Object)EventType.REGISTER_OPENING) + " : " + firstEntry);
        }
        this.opening = (RegisterLogEntry.RegisterEntry)firstEntry;
        this.parsed = doc;
        this.version = Integer.parseInt(doc.getRootElement().getAttributeValue(VERSION_ATTR_NAME, "1"));
        return this;
    }

    public final Document getDocument() {
        return this.parsed;
    }

    public final int getVersion() {
        return this.version;
    }

    public final RegisterLogEntry getLastEvent() throws ParseException {
        return this.getEvent(-1);
    }

    public final RegisterLogEntry getEvent(int index) throws ParseException {
        List<Element> elems = this.parsed.getRootElement().getChildren();
        return RegisterLogEntry.parseEntry(elems.get(CollectionUtils.getValidIndex(elems, index, true)));
    }

    public final List<RegisterLogEntry> getAllEvents() throws ParseException {
        List<Element> elems = this.parsed.getRootElement().getChildren();
        ArrayList<RegisterLogEntry> res = new ArrayList<RegisterLogEntry>();
        for (Element elem : elems) {
            res.add(RegisterLogEntry.parseEntry(elem));
        }
        return res;
    }

    public final String getLastReceiptHash() throws ParseException {
        RegisterLogEntry.ReceiptEntry lastReceiptCreationEvent = this.getLastReceiptCreationEvent();
        if (lastReceiptCreationEvent != null) {
            return lastReceiptCreationEvent.getFileHash();
        }
        return this.getFirstRegisterEvent().getLastReceiptHash();
    }

    public final int getRegisterID() {
        return this.getFirstRegisterEvent().getRegisterID();
    }

    public final RegisterLogEntry.RegisterEntry getFirstRegisterEvent() {
        return this.opening;
    }

    public final RegisterLogEntry.RegisterEntry getLastRegisterEvent() throws ParseException {
        RegisterLogEntry lastEvent = this.getLastEvent();
        if (lastEvent.getType() == EventType.REGISTER_CLOSURE) {
            return (RegisterLogEntry.RegisterEntry)lastEvent;
        }
        return this.opening;
    }

    public final RegisterState getRegisterState() throws ParseException {
        RegisterLogEntry.RegisterEntry lastRegisterEvent = this.getLastRegisterEvent();
        return new RegisterState(lastRegisterEvent.getType() == EventType.REGISTER_OPENING ? RegisterState.Status.OPEN : RegisterState.Status.CLOSED, lastRegisterEvent.getDate());
    }

    public final List<RegisterLogEntry.ReceiptEntry> getReceiptEvents() throws ParseException {
        List<Element> elems = this.parsed.getRootElement().getChildren();
        int size = elems.size();
        if (size <= 1) {
            return Collections.emptyList();
        }
        ArrayList<RegisterLogEntry.ReceiptEntry> res = new ArrayList<RegisterLogEntry.ReceiptEntry>();
        for (Element elem : elems.subList(1, size)) {
            RegisterLogEntry parsedEntry = RegisterLogEntry.parseEntry(elem);
            if (parsedEntry instanceof RegisterLogEntry.ReceiptEntry) {
                res.add((RegisterLogEntry.ReceiptEntry)parsedEntry);
                continue;
            }
            if (parsedEntry.getType() == EventType.REGISTER_CLOSURE) {
                if (res.size() == size - 2) continue;
                throw new IllegalStateException("Closure not at the end : " + elems);
            }
            throw new IllegalStateException("Unexpected entry : " + parsedEntry);
        }
        return res;
    }

    public final List<Ticket> parseReceipts() throws ParseException, IOException {
        ArrayList<Ticket> receipts = new ArrayList<Ticket>();
        Path toUse = this.getLogFile().getParent();
        List<RegisterLogEntry.ReceiptEntry> receiptEvents = this.getReceiptEvents();
        String lastHash = this.getFirstRegisterEvent().getLastReceiptHash();
        int index = 1;
        for (RegisterLogEntry.ReceiptEntry receiptEntry : receiptEvents) {
            Ticket receipt;
            Path receiptFile = toUse.resolve(receiptEntry.getCode().getFileName());
            try {
                receipt = Ticket.parseFile(receiptFile.toFile(), RegisterFiles.HashMode.equalTo(receiptEntry.getFileHash()));
            }
            catch (Exception e) {
                throw new IOException("Couldn't parse file of " + receiptEntry + " : " + receiptFile, e);
            }
            assert (receipt != null);
            if (!receipt.getCode().equals(receiptEntry.getCodeString())) {
                throw new IllegalStateException("Code mismatch");
            }
            if (!CompareUtils.equals(lastHash, receipt.getPreviousHash())) {
                throw new IllegalStateException("Previous hash mismatch for " + receiptEntry.getCodeString());
            }
            lastHash = receiptEntry.getFileHash();
            if (receipt.getNumber() != index) {
                throw new IllegalStateException("Invalid index, expected " + index + " got " + receipt.getNumber());
            }
            ++index;
            if (receipt.getCreationDate().compareTo(receiptEntry.getDate()) != 0) {
                throw new IllegalStateException("Date mismatch for " + receiptEntry.getCodeString() + " logged " + receiptEntry.getDate() + " but receipt " + receipt.getCreationDate());
            }
            receipts.add(receipt);
        }
        return receipts;
    }

    public final RegisterLogEntry.ReceiptEntry getLastReceiptCreationEvent() throws ParseException {
        int i = -1;
        while (i >= -2) {
            RegisterLogEntry event = this.getEvent(i);
            if (event.getType() == EventType.REGISTER_OPENING) {
                return null;
            }
            if (event.getType() == EventType.RECEIPT_CREATION) {
                return (RegisterLogEntry.ReceiptEntry)event;
            }
            --i;
        }
        throw new IllegalStateException("2 " + (Object)((Object)EventType.REGISTER_CLOSURE));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getLogFile() + " opened " + this.getFirstRegisterEvent().getDate();
    }

    public static enum EventType {
        REGISTER_OPENING,
        RECEIPT_CREATION,
        REGISTER_CLOSURE;

    }
}

