/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

public class Barcode {
    public static final String AIM_PREFIX_CODE39_NOCHECK = "]A0";
    public static final String AIM_PREFIX_CODE39_CHECKED = "]A1";
    public static final String AIM_PREFIX_CODE39_CHECKED_STRIPPED = "]A2";
    public static final String AIM_PREFIX_CODE39_ASCII = "]A4";
    public static final String AIM_PREFIX_CODE39_ASCII_CHECKED = "]A5";
    public static final String AIM_PREFIX_CODE39_ASCII_STRIPPED = "]A7";
    public static final String AIM_PREFIX_TELEPEN_ASCII = "]B0";
    public static final String AIM_PREFIX_TELEPEN_DD = "]B1";
    public static final String AIM_PREFIX_TELEPEN_DD_ASCII = "]B2";
    public static final String AIM_PREFIX_TELEPEN_ASCII_DD = "]B4";
    public static final String AIM_PREFIX_CODE128 = "]C0";
    public static final String AIM_PREFIX_CODE128_C1 = "]C1";
    public static final String AIM_PREFIX_CODE128_C2 = "]C2";
    public static final String AIM_PREFIX_CODE128_ISBT = "]C4";
    public static final String AIM_PREFIX_EAN = "]E0";
    public static final String AIM_PREFIX_EAN_2S = "]E1";
    public static final String AIM_PREFIX_EAN_5S = "]E2";
    public static final String AIM_PREFIX_EAN_25S = "]E3";
    public static final String AIM_PREFIX_EAN8 = "]E4";
    public static final String AIM_PREFIX_CODABAR = "]F0";
    public static final String AIM_PREFIX_CODABAR_CHECKED = "]F1";
    public static final String AIM_PREFIX_CODABAR_VALIDATED = "]F3";
    public static final String AIM_PREFIX_CODABAR_VALIDATED_STRIPPED = "]F3";
    public static final String AIM_PREFIX_CODE93 = "]G0";
    public static final String AIM_PREFIX_CODE11_SD = "]H0";
    public static final String AIM_PREFIX_CODE11_TD = "]H1";
    public static final String AIM_PREFIX_CODE11_CHECKED = "]H3";
    public static final String AIM_PREFIX_PDF417 = "]L0";
    public static final String AIM_PREFIX_PDF417_ENV12925 = "]L1";
    public static final String AIM_PREFIX_PDF417_BASIC = "]L2";
    public static final String AIM_PREFIX_PDF417_CODE128_FNC1_1 = "]L3";
    public static final String AIM_PREFIX_PDF417_CODE128_FNC1_2 = "]L4";
    public static final String AIM_PREFIX_PDF417_CODE128 = "]L5";
    public static final String AIM_PREFIX_MSI_PLESSEY = "]M0";
    public static final String AIM_PREFIX_MSI_PLESSEY_2 = "]M1";
    public static final String AIM_PREFIX_QRCODE_1 = "]Q0";
    public static final String AIM_PREFIX_QRCODE_2 = "]Q1";
    public static final String AIM_PREFIX_QRCODE_2_ECI = "]Q2";
    public static final String AIM_PREFIX_QRCODE_2_FNC1 = "]Q3";
    public static final String AIM_PREFIX_QRCODE_2_FNC1_ECI = "]Q4";
    public static final String AIM_PREFIX_QRCODE_2_FNC1_2 = "]Q5";
    public static final String AIM_PREFIX_QRCODE_2_FNC1_2_ECI = "]Q6";
    public static final String AIM_PREFIX_NO_BARECODE = "]Z";
    public static final String AIM_PREFIX_DATAMATRIX_ECC140 = "]d0";
    public static final String AIM_PREFIX_DATAMATRIX_ECC200 = "]d1";
    public static final String AIM_PREFIX_DATAMATRIX_ECC200_FNC1_1 = "]d2";
    public static final String AIM_PREFIX_DATAMATRIX_ECC200_FNC1_2 = "]d3";
    public static final String AIM_PREFIX_DATAMATRIX_ECC200_ECI = "]d4";
    public static final String AIM_PREFIX_DATAMATRIX_ECC200_FNC1_1_ECI = "]d5";
    public static final String AIM_PREFIX_DATAMATRIX_ECC200_FNC1_2_ECI = "]d6";
    public static final String AIM_PREFIX_DATAMATRIX_GS1 = "]e0";
    public static final String AIM_PREFIX_DATAMATRIX_GS1_SEP = "]e1";
    public static final String AIM_PREFIX_DATAMATRIX_GS1_ESC = "]e2";
    public static final String AIM_PREFIX_DATAMATRIX_GS1_ESC_ECI = "]e3";
    private String code;

    public Barcode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getData() {
        if (this.code.length() > 3 && this.getType() != BarcodeType.UNKNOWN) {
            return this.code.substring(3);
        }
        return this.code;
    }

    public BarcodeType getType() {
        if (this.code.length() > 3 && this.code.charAt(0) == ']') {
            char c = this.code.charAt(1);
            if (c == 'A') {
                return BarcodeType.CODE39;
            }
            if (c == 'B') {
                return BarcodeType.TELEPEN;
            }
            if (c == 'C') {
                return BarcodeType.CODE128;
            }
            if (c == 'E') {
                return BarcodeType.EAN;
            }
            if (c == 'F') {
                return BarcodeType.CODABAR;
            }
            if (c == 'G') {
                return BarcodeType.CODE93;
            }
            if (c == 'H') {
                return BarcodeType.CODE11;
            }
            if (c == 'L') {
                return BarcodeType.PDF417;
            }
            if (c == 'M') {
                return BarcodeType.MSIPLESSEY;
            }
            if (c == 'Q') {
                return BarcodeType.QRCODE;
            }
            if (c == 'd') {
                return BarcodeType.DATAMATRIX;
            }
            if (c == 'e') {
                return BarcodeType.GS1;
            }
        }
        return BarcodeType.UNKNOWN;
    }

    public static enum BarcodeType {
        CODE39,
        TELEPEN,
        CODE128,
        EAN,
        CODABAR,
        CODE93,
        CODE11,
        PDF417,
        MSIPLESSEY,
        QRCODE,
        DATAMATRIX,
        GS1,
        UNKNOWN;

    }
}

