/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.element;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.ArticleCache;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.TicketClientNamePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.utils.PartialUniqueTrigger;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.action.SQLRowValuesAction;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;

public class TicketCaisseSQLElement
extends ComptaSQLConfElement {
    public static final String UNARCHIVED_WHERE = String.valueOf(SQLBase.quoteIdentifier("ARCHIVE")) + " = " + 0;
    public static final String DATE_WHERE = String.valueOf(UNARCHIVED_WHERE) + " and " + SQLBase.quoteIdentifier("FILE_HASH") + " is not null";

    public TicketCaisseSQLElement() {
        super("TICKET_CAISSE", "un ticket de caisse", "tickets de caisses");
        SQLRowValuesAction.PredicateRowAction action = new SQLRowValuesAction.PredicateRowAction(true, "ticket.document.generate", le -> {
            POSConfiguration posConf = POSConfiguration.getInstance();
            try {
                if (posConf == null) {
                    posConf = POSConfiguration.setInstance();
                    ArticleCache.initCache(this.getDirectory());
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible d'initialiser la configuration de la caisse", e);
                return;
            }
            TicketClientNamePanel p = new TicketClientNamePanel(null, this.createTicket(le.getSelectedRow().asRow()));
            JFrame f = new JFrame("Facturation ticket");
            f.add(p);
            FrameUtil.showPacked(f);
        });
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowValuesActions().add(action);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CAISSE");
        l.add("TOTAL_HT");
        l.add("TOTAL_TTC");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addRequiredSQLObject(new JTextField(), "NOM", "right");
            }
        };
    }

    public Ticket createTicket(SQLRow row) {
        Ticket t;
        try {
            t = new Ticket(new ReceiptCode(row.getString("NUMERO")), row.getDate("DATE"), row.getString("FILE_HASH_PREVIOUS"));
        }
        catch (ParseException e) {
            throw new IllegalStateException("Couldn't parse " + row, e);
        }
        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
        SQLElement eltEncaisser = directory.getElement("ENCAISSER_MONTANT");
        Collection l = row.getReferentRows(eltEncaisser.getTable());
        for (SQLRow row2 : l) {
            long montant = row2.getLong("MONTANT");
            SQLRow rowMode = row2.getForeign("ID_MODE_REGLEMENT");
            int type = 3;
            if (rowMode.getInt("ID_TYPE_REGLEMENT") == 3) {
                type = 3;
            } else if (rowMode.getInt("ID_TYPE_REGLEMENT") == 2) {
                type = 2;
            } else if (rowMode.getInt("ID_TYPE_REGLEMENT") == 4) {
                type = 1;
            }
            Paiement p = new Paiement(type);
            p.setMontantInCents((int)montant);
            t.addPaiement(p);
        }
        SQLElement eltArticle = directory.getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLSelect selUniteVente = new SQLSelect();
        selUniteVente.addSelectStar(directory.getElement("UNITE_VENTE").getTable());
        HashMap<Integer, String> mapUniteVenteName = new HashMap<Integer, String>();
        for (SQLRow rowUniteVente : SQLRowListRSH.execute(selUniteVente)) {
            mapUniteVenteName.put(rowUniteVente.getID(), rowUniteVente.getString("CODE"));
        }
        Collection l2 = row.getReferentRows(eltArticle.getTable());
        Categorie c = new Categorie("");
        for (SQLRow row2 : l2) {
            Article a = new Article(c, row2.getString("NOM"), row2.getInt("ID_ARTICLE"));
            if (row2.getInt("ID_UNITE_VENTE") != 2) {
                a.setSalesUnit((String)mapUniteVenteName.get(row2.getInt("ID_UNITE_VENTE")));
            }
            BigDecimal ht = (BigDecimal)row2.getObject("PV_HT");
            a.setPriceWithoutTax(ht);
            BigDecimal percentRemise = row2.getBigDecimal("POURCENT_REMISE");
            if (percentRemise != null) {
                a.setDiscountPct(percentRemise.movePointLeft(2));
            }
            int idTaxe = row2.getInt("ID_TAXE");
            float tva = TaxeCache.getCache().getTauxFromId(idTaxe).floatValue();
            a.setPriceWithTax(ht.multiply(BigDecimal.valueOf(1.0 + (double)tva / 100.0), DecimalUtils.HIGH_PRECISION));
            a.setIdTaxe(idTaxe);
            t.addArticle(a);
            if (a.getSalesUnit() == null) {
                t.setArticleCount(a, new BigDecimal(row2.getInt("QTE")));
                continue;
            }
            t.setArticleCount(a, row2.getBigDecimal("QTE_UNITAIRE"));
        }
        return t;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".ticket";
    }

    public static final class UniqueDate_PartialUniqueTrigger
    extends PartialUniqueTrigger {
        public UniqueDate_PartialUniqueTrigger() {
            super(Arrays.asList("ID_CAISSE", "DATE"), DATE_WHERE);
        }
    }

    public static final class UniqueNumber_PartialUniqueTrigger
    extends PartialUniqueTrigger {
        public UniqueNumber_PartialUniqueTrigger() {
            super(Arrays.asList("NUMERO"), UNARCHIVED_WHERE);
        }
    }
}

