/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.finance.accounting.ui.ListeGestCommEltPanel;
import org.openconcerto.erp.core.sales.invoice.ui.DateEnvoiRenderer;
import org.openconcerto.erp.core.sales.invoice.ui.ListeFactureRenderer;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.element.TicketCaisseSQLElement;
import org.openconcerto.erp.core.sales.pos.model.ArticleCache;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPanel;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;

public class ListeDesVentesPanel
extends JPanel {
    private ListeGestCommEltPanel listeFact;
    private JLabelBold textField = new JLabelBold("0");
    private JLabelBold textField2 = new JLabelBold("0");

    public ListeDesVentesPanel(ComptaPropsConfiguration conf) {
        SQLElement elementVF;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 1;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JTabbedPane tabbedPane = new JTabbedPane();
        final SQLElementDirectory dir = conf.getDirectory();
        final SQLElement eltFacture = elementVF = dir.getElement("SAISIE_VENTE_FACTURE");
        SQLTableModelSourceOnline src = eltFacture.getTableSource(true);
        Where wPrev = new Where((FieldRef)eltFacture.getTable().getField("PREVISIONNELLE"), "=", (Object)Boolean.FALSE);
        if (src.getReq().getWhere() != null) {
            wPrev = wPrev.and(src.getReq().getWhere());
        }
        src.getReq().putWhere("Previsionnelle", wPrev);
        for (SQLTableModelColumn column : src.getColumns()) {
            if (column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) {
                ((SQLTableModelColumnPath)column).setEditable(false);
            }
            if (column.getName().startsWith("Avancement")) continue;
            column.setRenderer(new ListeFactureRenderer());
        }
        SQLTableModelColumn dateEnvoiCol = src.getColumn(eltFacture.getTable().getField("DATE_ENVOI"));
        ((SQLTableModelColumnPath)dateEnvoiCol).setEditable(true);
        SQLTableModelColumn dateReglCol = src.getColumn(eltFacture.getTable().getField("DATE_REGLEMENT"));
        if (dateReglCol != null) {
            ((SQLTableModelColumnPath)dateReglCol).setEditable(true);
        }
        dateEnvoiCol.setColumnInstaller(new IClosure<TableColumn>(){

            @Override
            public void executeChecked(TableColumn columnDateEnvoi) {
                TimestampTableCellEditor cellEditor = new TimestampTableCellEditor();
                cellEditor.setAllowNull(true);
                columnDateEnvoi.setCellEditor(cellEditor);
                columnDateEnvoi.setCellRenderer(new DateEnvoiRenderer());
            }
        });
        if (dateReglCol != null) {
            dateReglCol.setColumnInstaller(new IClosure<TableColumn>(){

                @Override
                public void executeChecked(TableColumn columnDateReglement) {
                    TimestampTableCellEditor cellEditor = new TimestampTableCellEditor();
                    cellEditor.setAllowNull(true);
                    columnDateReglement.setCellEditor(cellEditor);
                    columnDateReglement.setCellRenderer(new DateEnvoiRenderer());
                }
            });
        }
        src.getColumns().add(new SQLTableModelColumnPath(new FieldPath((Path)new Path(eltFacture.getTable()).addForeignField("ID_SDD_MESSAGE"), "MessageIdentification")));
        this.listeFact = new ListeGestCommEltPanel(eltFacture, new IListe(src), true);
        this.listeFact.setOpaque(false);
        this.listeFact.getListe().setModificationAllowed(true);
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction(TM.tr("display", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowAccessor row = IListe.get(e).getSelectedRowAccessor();
                EditFrame editModifyFrame = eltFacture.getTable().getName().equals("SAISIE_VENTE_FACTURE") && row.getBoolean("PARTIAL") != false ? new EditFrame(eltFacture.createComponent("sales.invoice.partial"), EditPanel.READONLY) : (eltFacture.getTable().getName().equals("SAISIE_VENTE_FACTURE") && row.getBoolean("SOLDE") != false ? new EditFrame(eltFacture.createComponent("sales.invoice.partial.balance"), EditPanel.READONLY) : new EditFrame(eltFacture, EditPanel.READONLY));
                editModifyFrame.selectionId(row.getID());
                editModifyFrame.setVisible(true);
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.listeFact.getListe().setDefaultRowAction(action);
        JTable tableFact = this.listeFact.getListe().getJTable();
        SQLTableModelColumn numeroCol = src.getColumn(eltFacture.getTable().getField("NUMERO"));
        ((TableSorter)tableFact.getModel()).setSortingStatus(src.getColumns().indexOf(numeroCol), 1);
        BaseSQLTableModelColumn totalAvoirHT = new BaseSQLTableModelColumn("Fact. - Avoir HT", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                BigDecimal bF = new BigDecimal(r.getLong("T_HT")).movePointLeft(2);
                if (!r.isForeignEmpty("ID_AVOIR_CLIENT")) {
                    BigDecimal b = new BigDecimal(r.getForeign("ID_AVOIR_CLIENT").getLong("MONTANT_HT")).movePointLeft(2);
                    return bF.subtract(b);
                }
                return bF;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(eltFacture.getTable());
                p = (Path)p.add(eltFacture.getTable().getField("ID_AVOIR_CLIENT"));
                return CollectionUtils.createSet(new FieldPath(p, "MONTANT_HT"));
            }
        };
        src.getColumns().add(src.getColumns().indexOf(src.getColumn(eltFacture.getTable().getField("T_HT"))), totalAvoirHT);
        JPanel panelFacture = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cFacture = new DefaultGridBagConstraints();
        ++cFacture.gridy;
        cFacture.gridx = 0;
        cFacture.weighty = 1.0;
        cFacture.weightx = 1.0;
        cFacture.gridwidth = 0;
        cFacture.fill = 1;
        panelFacture.add((Component)this.listeFact, cFacture);
        ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> l = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>();
        if (this.listeFact.getListe().getSource().getColumn(eltFacture.getTable().getField("T_HA")) != null) {
            l.add(Tuple2.create(src.getColumn(eltFacture.getTable().getField("T_HA")), IListTotalPanel.Type.SOMME));
        }
        l.add(Tuple2.create(totalAvoirHT, IListTotalPanel.Type.SOMME));
        l.add(Tuple2.create(src.getColumn(eltFacture.getTable().getField("T_HT")), IListTotalPanel.Type.SOMME));
        l.add(Tuple2.create(src.getColumn(eltFacture.getTable().getField("T_TTC")), IListTotalPanel.Type.SOMME));
        IListTotalPanel total = new IListTotalPanel(this.listeFact.getListe(), l, null, "Total");
        cFacture.weighty = 0.0;
        cFacture.fill = 0;
        ++cFacture.gridy;
        cFacture.anchor = 13;
        total.setOpaque(false);
        panelFacture.add((Component)total, cFacture);
        IListFilterDatePanel filterDate = new IListFilterDatePanel(this.listeFact.getListe(), eltFacture.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cFacture.weighty = 0.0;
        cFacture.fill = 2;
        ++cFacture.gridy;
        filterDate.setOpaque(false);
        panelFacture.add((Component)filterDate, cFacture);
        tabbedPane.add("Ventes avec facture", panelFacture);
        RowAction.PredicateRowAction actionRegle = new RowAction.PredicateRowAction(new AbstractAction("Facture r\u00e9gl\u00e9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                for (SQLRowAccessor sQLRowAccessor : selectedRows) {
                    SQLRowValues rowVals = sQLRowAccessor.asRow().createEmptyUpdateRow();
                    rowVals.put("DATE_REGLEMENT", new Date());
                    try {
                        rowVals.update();
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("Modification impossible", e1);
                    }
                }
            }
        }, true);
        actionRegle.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.listeFact.getListe().addIListeAction(actionRegle);
        RowAction.PredicateRowAction actionEnvoye = new RowAction.PredicateRowAction(new AbstractAction("Facture envoy\u00e9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                for (SQLRowAccessor sQLRowAccessor : selectedRows) {
                    SQLRowValues rowVals = sQLRowAccessor.asRow().createEmptyUpdateRow();
                    rowVals.put("DATE_ENVOI", new Date());
                    try {
                        rowVals.update();
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("Modification impossible", e1);
                    }
                }
            }
        }, true);
        actionEnvoye.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.listeFact.getListe().addIListeAction(actionEnvoye);
        final TicketCaisseSQLElement ticketElement = dir.getElement(TicketCaisseSQLElement.class);
        ListeViewPanel panelTicket = new ListeViewPanel(ticketElement){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonModifier) {
                    POSConfiguration posConf = POSConfiguration.getInstance();
                    try {
                        if (posConf == null) {
                            posConf = POSConfiguration.setInstance();
                            ArticleCache.initCache(dir);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(source, "Impossible d'initialiser la configuration de la caisse", e);
                        return;
                    }
                    new PanelFrame(new TextAreaTicketPanel(ticketElement, posConf, this.getListe().fetchSelectedRow()), "Ticket").setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cc = new DefaultGridBagConstraints();
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        cc.fill = 1;
        panel.add((Component)panelTicket, cc);
        ArrayList<SQLField> l2 = new ArrayList<SQLField>();
        l2.add(panelTicket.getElement().getTable().getField("TOTAL_HT"));
        l2.add(panelTicket.getElement().getTable().getField("TOTAL_TTC"));
        IListTotalPanel total2 = new IListTotalPanel(panelTicket.getListe(), l2);
        cc.weighty = 0.0;
        cc.fill = 0;
        ++cc.gridy;
        cc.anchor = 13;
        total2.setOpaque(false);
        panel.add((Component)total2, cc);
        IListFilterDatePanel filterDate2 = new IListFilterDatePanel(panelTicket.getListe(), panelTicket.getElement().getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cc.weighty = 0.0;
        cc.fill = 2;
        ++cc.gridy;
        filterDate2.setOpaque(false);
        panel.add((Component)filterDate2, cc);
        tabbedPane.add("Ventes caisse", panel);
        ListeGestCommEltPanel listeVC = new ListeGestCommEltPanel(dir.getElement("SAISIE_VENTE_COMPTOIR"), true);
        listeVC.getListe().setModificationAllowed(false);
        listeVC.setOpaque(false);
        JTable table = listeVC.getListe().getJTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumnClass(i) == Long.class || table.getColumnClass(i) == BigInteger.class) {
                table.getColumnModel().getColumn(i).setCellRenderer(new ListeFactureRenderer());
            }
            ++i;
        }
        JPanel panelComptoir = new JPanel(new GridBagLayout());
        cc = new DefaultGridBagConstraints();
        cc.weightx = 1.0;
        cc.weighty = 1.0;
        cc.fill = 1;
        panelComptoir.add((Component)listeVC, cc);
        l2 = new ArrayList();
        l2.add(listeVC.getElement().getTable().getField("MONTANT_HT"));
        l2.add(listeVC.getElement().getTable().getField("MONTANT_TTC"));
        total2 = new IListTotalPanel(listeVC.getListe(), l2);
        cc.weighty = 0.0;
        cc.fill = 0;
        ++cc.gridy;
        cc.anchor = 13;
        total2.setOpaque(false);
        panelComptoir.add((Component)total2, cc);
        filterDate2 = new IListFilterDatePanel(listeVC.getListe(), listeVC.getElement().getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        cc.weighty = 0.0;
        cc.fill = 2;
        ++cc.gridy;
        filterDate2.setOpaque(false);
        panelComptoir.add((Component)filterDate2, cc);
        tabbedPane.add("Ventes comptoir", panelComptoir);
        this.add((Component)tabbedPane, c);
    }
}

