/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.ui.VerticalLayout;

public class InvoicePercentRenderer
extends JPanel {
    private int v = 0;
    private JLabel l1 = new JLabel("100 %", 0);
    private JLabel l2 = new JLabel("100 %", 0);
    private boolean affacturer = false;
    private boolean soldeAvoir = false;

    public InvoicePercentRenderer() {
        this.l1.setForeground(Color.WHITE);
        this.l2.setForeground(Color.BLACK);
    }

    public void setValue(Number value) {
        if (value == null) {
            value = 0;
        }
        this.v = value.intValue();
        String text = String.valueOf(this.v) + " %";
        this.l1.setText(text);
        this.l2.setText(text);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.l1.setBounds(x, y, width, height);
        this.l2.setBounds(x, y, width, height);
        super.setBounds(x, y, width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.l1.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.l1.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.l1.getMaximumSize();
    }

    public void setSoldeAvoir(boolean soldeAvoir) {
        this.soldeAvoir = soldeAvoir;
    }

    public void setAffacturer(boolean affacturer) {
        this.affacturer = affacturer;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth() * this.v / 100;
        int height = this.getHeight();
        int y = 0;
        if (g.getClipBounds() != null) {
            height = g.getClipBounds().height;
            y = g.getClipBounds().y;
        }
        if (this.v < 100) {
            g.setColor(Color.WHITE);
            g.fillRect(0, y, this.getWidth(), height);
        }
        if (width > 0) {
            if (this.v < 10) {
                g.setColor(Color.ORANGE);
            } else if (this.v >= 100) {
                if (this.affacturer) {
                    g.setColor(new Color(238, 200, 126));
                } else if (this.soldeAvoir) {
                    g.setColor(new Color(102, 153, 238));
                } else {
                    g.setColor(new Color(25, 169, 4));
                }
            } else {
                g.setColor(new Color(70, 130, 180));
            }
            g.fillRect(0, y, width, height);
            g.setClip(0, y, width, height);
            this.l1.paint(g);
        }
        g.setClip(width, y, this.getWidth() - width, height);
        this.l2.paint(g);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new VerticalLayout());
        int i = 0;
        while (i <= 100) {
            InvoicePercentRenderer r1 = new InvoicePercentRenderer();
            r1.setValue(i);
            r1.setSize(100, 16);
            p.add(r1);
            i += 4;
        }
        f.setContentPane(p);
        f.setSize(100, 500);
        f.setVisible(true);
    }
}

