/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.generationDoc.gestcomm.EtatVentesXmlSheet;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.NoneSelectedButtonGroup;
import org.openconcerto.utils.Tuple2;

public class EtatVentesPanel
extends JPanel
implements ActionListener {
    private JDate du;
    private JDate au;
    private JButton buttonGen = new JButton("Cr\u00e9er");
    private JButton buttonClose = new JButton("Fermer");
    private JCheckBox boxTicket = new JCheckBox("Uniquement les ventes en caisse");
    private JCheckBox boxFacture = new JCheckBox("Uniquement les ventes sur facture");

    public EtatVentesPanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 13;
        this.add((Component)new JLabelBold("Etat des Ventes"), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.anchor = 17;
        final Map<String, Tuple2<Date, Date>> map = IListFilterDatePanel.getDefaultMap();
        if (map != null && map.keySet().size() > 0) {
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(1, 0, 1));
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Date d1 = cal.getTime();
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            Date d2 = cal.getTime();
            map.put("Aujourd'hui", Tuple2.create(d1, d2));
            for (String s : map.keySet()) {
                model.addElement(s);
            }
            final JComboBox combo = new JComboBox(model);
            c.weightx = 0.0;
            c.gridwidth = 4;
            p.add(new JLabel("P\u00e9riode "));
            p.add(combo);
            c.fill = 0;
            this.add((Component)p, c);
            ++c.gridy;
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = (String)combo.getSelectedItem();
                    EtatVentesPanel.this.setPeriode((Tuple2)map.get(s));
                }
            });
        }
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Du"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.du = new JDate(false);
        this.add((Component)this.du, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.au = new JDate(false);
        this.add((Component)this.au, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.boxTicket, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.boxFacture, c);
        NoneSelectedButtonGroup grou = new NoneSelectedButtonGroup();
        grou.add(this.boxFacture);
        grou.add(this.boxTicket);
        ++c.gridy;
        c.gridx = 0;
        JPanel panelButton = new JPanel();
        panelButton.add(this.buttonGen);
        panelButton.add(this.buttonClose);
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 14;
        c.weightx = 1.0;
        this.add((Component)panelButton, c);
        this.buttonGen.addActionListener(this);
        this.buttonClose.addActionListener(this);
    }

    public void setPeriode(Tuple2<Date, Date> t) {
        if (t == null) {
            this.setPeriode(null, null);
        } else {
            this.setPeriode(t.get0(), t.get1());
        }
    }

    public void setDateDu(Date d) {
        if (d != null) {
            d.setHours(0);
            d.setMinutes(0);
        }
        this.du.setValue(d);
    }

    public void setDateAu(Date d) {
        if (d != null) {
            d.setHours(23);
            d.setMinutes(59);
        }
        this.au.setValue(d);
    }

    private void setPeriode(Date du, Date au) {
        this.setDateAu(au);
        this.setDateDu(du);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonGen) {
            Date start = this.du.getDate();
            Date stop = this.au.getDate();
            EtatVentesXmlSheet sheet = new EtatVentesXmlSheet(start, stop, this.boxTicket.isSelected(), this.boxFacture.isSelected());
            try {
                sheet.createDocumentAsynchronous().get();
                sheet.openDocument(false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ((JFrame)SwingUtilities.getRoot(this)).dispose();
    }
}

