/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class SituationCompteXmlSheet
extends AbstractListeSheetXml {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private SQLElement eltEch;
    private SQLElement eltVf;
    private ComptaPropsConfiguration conf;
    private Date d;

    public SituationCompteXmlSheet(ComptaPropsConfiguration conf, SQLRow rowClient) {
        super(rowClient);
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.eltEch = conf.getDirectory().getElement("ECHEANCE_CLIENT");
        this.conf = conf;
    }

    @Override
    protected String getStoragePathP() {
        return "Autres";
    }

    @Override
    public String getDefaultTemplateId() {
        return "SituationCompte";
    }

    @Override
    public String getName() {
        if (this.d == null) {
            this.d = new Date();
        }
        return "SituationCompte-" + this.d.getTime();
    }

    @Override
    protected void createListeValues() {
        SQLTable echTable = this.eltEch.getTable();
        SQLRowValues rowVals = new SQLRowValues(echTable);
        rowVals.putNulls("DATE", "MONTANT");
        rowVals.putRowValues("ID_SAISIE_VENTE_FACTURE").putNulls("NUMERO", "NET_A_PAYER", "T_AVOIR_TTC", "DATE", "NOM").putRowValues("ID_AVOIR_CLIENT").putNulls("NUMERO", "DATE");
        Where w = new Where((FieldRef)echTable.getField("REGLE"), "=", (Object)Boolean.FALSE);
        w = w.and(new Where((FieldRef)echTable.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
        w = w.and(new Where((FieldRef)echTable.getField("ID_CLIENT"), "=", this.row.getID()));
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        List<SQLRowValues> result = fetcher.fetch(w);
        Collections.sort(result, new Comparator<SQLRowValues>(){

            @Override
            public int compare(SQLRowValues o1, SQLRowValues o2) {
                return o1.getDate("DATE").compareTo(o2.getDate("DATE"));
            }
        });
        Collections.sort(result, new Comparator<SQLRowValues>(){

            @Override
            public int compare(SQLRowValues o1, SQLRowValues o2) {
                return o1.getDate("DATE").compareTo(o2.getDate("DATE"));
            }
        });
        ArrayList listValues = new ArrayList();
        HashMap<Integer, String> styleValues = new HashMap<Integer, String>();
        BigDecimal totalRegle = BigDecimal.ZERO;
        BigDecimal totalEch = BigDecimal.ZERO;
        BigDecimal totalEchPasse = BigDecimal.ZERO;
        Calendar today = Calendar.getInstance();
        for (SQLRowValues sqlRow : result) {
            Object regle;
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            Calendar dateEch = sqlRow.getDate("DATE");
            mValues.put("DATE_ECHEANCE", this.dateFormat.format(dateEch.getTime()));
            BigDecimal montantDu = new BigDecimal(sqlRow.getLong("MONTANT"));
            mValues.put("DU", montantDu.movePointLeft(2));
            totalEch = totalEch.add(montantDu);
            SQLRowAccessor rowFact = sqlRow.getNonEmptyForeign("ID_SAISIE_VENTE_FACTURE");
            if (rowFact != null) {
                mValues.put("PIECE", rowFact.getString("NUMERO"));
                mValues.put("LIBELLE", rowFact.getString("NOM"));
                mValues.put("DATE", this.dateFormat.format(rowFact.getDate("DATE").getTime()));
                BigDecimal montantFact = new BigDecimal(rowFact.getLong("NET_A_PAYER"));
                regle = montantFact.subtract(montantDu);
                mValues.put("DU", montantFact.movePointLeft(2));
                if (!rowFact.isForeignEmpty("ID_AVOIR_CLIENT")) {
                    mValues.put("AVOIR_TTC", new BigDecimal(rowFact.getLong("T_AVOIR_TTC")).movePointLeft(2));
                    mValues.put("AVOIR_NUMERO", rowFact.getForeign("ID_AVOIR_CLIENT").getString("NUMERO"));
                }
                mValues.put("REGLE", montantFact.subtract(montantDu).movePointLeft(2));
                mValues.put("SOLDE", montantDu.movePointLeft(2));
            } else {
                regle = BigDecimal.ZERO;
                mValues.put("SOLDE", montantDu.movePointLeft(2));
            }
            if (dateEch.before(today)) {
                totalEchPasse = totalEchPasse.add(montantDu);
                styleValues.put(listValues.size(), "Normal");
            } else {
                styleValues.put(listValues.size(), "Titre 1");
            }
            totalRegle = totalRegle.add((BigDecimal)regle);
            listValues.add(mValues);
        }
        SQLTable avoirTable = echTable.getTable("AVOIR_CLIENT");
        SQLRowValues rowValsAvoir = new SQLRowValues(avoirTable);
        rowValsAvoir.putNulls("NUMERO", "MONTANT_TTC", "MONTANT_SOLDE", "MONTANT_RESTANT", "DATE", "NOM");
        Where wA = new Where((FieldRef)avoirTable.getField("SOLDE"), "=", (Object)Boolean.FALSE);
        wA = wA.and(new Where((FieldRef)avoirTable.getField("ID_CLIENT"), "=", this.row.getID()));
        wA = wA.and(new Where((FieldRef)avoirTable.getField("MONTANT_RESTANT"), ">", 0));
        SQLRowValuesListFetcher fetcherA = SQLRowValuesListFetcher.create(rowValsAvoir);
        List<SQLRowValues> resultA = fetcherA.fetch(wA);
        Collections.sort(resultA, new Comparator<SQLRowValues>(){

            @Override
            public int compare(SQLRowValues o1, SQLRowValues o2) {
                return o1.getDate("DATE").compareTo(o2.getDate("DATE"));
            }
        });
        if (!resultA.isEmpty()) {
            listValues.add(new HashMap());
        }
        for (SQLRowValues sqlRow : resultA) {
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            Calendar dateEch = sqlRow.getDate("DATE");
            mValues.put("DATE_ECHEANCE", this.dateFormat.format(dateEch.getTime()));
            BigDecimal montantDu = new BigDecimal(sqlRow.getLong("MONTANT_RESTANT")).movePointLeft(2).negate();
            mValues.put("DU", montantDu);
            totalEch = totalEch.add(montantDu.movePointRight(2));
            totalEchPasse = totalEchPasse.add(montantDu.movePointRight(2));
            mValues.put("PIECE", sqlRow.getString("NUMERO"));
            mValues.put("LIBELLE", sqlRow.getString("NOM"));
            mValues.put("DATE", this.dateFormat.format(sqlRow.getDate("DATE").getTime()));
            styleValues.put(listValues.size(), "Normal");
            listValues.add(mValues);
        }
        SQLRow rowSoc = this.conf.getRowSociete();
        SQLRow adrSoc = rowSoc.getForeign("ID_ADRESSE_COMMON");
        HashMap<String, Object> sheetVals = new HashMap<String, Object>();
        sheetVals.put("TOTAL_REGLE", totalRegle.movePointLeft(2));
        sheetVals.put("TOTAL_ECHEANCE", totalEch.movePointLeft(2));
        sheetVals.put("TOTAL_FUTUR", totalEch.subtract(totalEchPasse).movePointLeft(2));
        sheetVals.put("TOTAL_PASSE", totalEchPasse.movePointLeft(2));
        sheetVals.put("NOM_CLIENT", this.row.getString("NOM"));
        sheetVals.put("DATE", this.dateFormat.format(new Date()));
        sheetVals.put("CODE_CLIENT", this.row.getString("CODE"));
        sheetVals.put("TELEPHONE", this.row.getString("TEL"));
        SQLRow rowAdrClient = this.row.getForeign("ID_ADRESSE");
        sheetVals.put("ADRESSE", rowAdrClient.getString("RUE"));
        sheetVals.put("VILLE", String.valueOf(rowAdrClient.getString("CODE_POSTAL")) + " " + rowAdrClient.getString("VILLE"));
        sheetVals.put("SOCIETE_NOM", rowSoc.getString("NOM"));
        sheetVals.put("SOCIETE_TEL", rowSoc.getString("NUM_TEL"));
        sheetVals.put("SOCIETE_SIRET", rowSoc.getString("NUM_SIRET"));
        sheetVals.put("SOCIETE_APE", rowSoc.getString("NUM_APE"));
        sheetVals.put("SOCIETE_NII", rowSoc.getString("NUM_NII"));
        sheetVals.put("SOCIETE_BIC", rowSoc.getString("BIC"));
        sheetVals.put("SOCIETE_IBAN", rowSoc.getString("IBAN"));
        sheetVals.put("SOCIETE_MAIL", rowSoc.getString("MAIL"));
        sheetVals.put("SOCIETE_ADRESSE", adrSoc.getString("RUE"));
        sheetVals.put("SOCIETE_VILLE", String.valueOf(adrSoc.getString("CODE_POSTAL")) + " " + adrSoc.getString("VILLE"));
        this.mapAllSheetValues.put(0, sheetVals);
        this.listAllSheetValues.put(0, listValues);
        this.styleAllSheetValues.put(0, styleValues);
    }
}

