/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.invoice.report.SituationCompteXmlSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class SituationCompteClientPanel
extends JPanel {
    public SituationCompteClientPanel(final ComptaPropsConfiguration conf) {
        super(new GridBagLayout());
        JLabelBold title = new JLabelBold("G\u00e9n\u00e9ration d'une situation de compte d'un client");
        final ElementComboBox box = new ElementComboBox(true);
        SQLElement element = Configuration.getInstance().getDirectory().getElement("CLIENT");
        ComboSQLRequest comboRequest = element.getComboRequest(true);
        box.init(element, comboRequest);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)title, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)box, c);
        final JCheckBox boxMail = new JCheckBox("Envoie par mail");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)boxMail, c);
        final JButton buttonValid = new JButton(new AbstractAction("Valider"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLRow selectedClient = box.getSelectedRow();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            SituationCompteXmlSheet sheet = new SituationCompteXmlSheet(conf, selectedClient);
                            File pdf = sheet.getOrCreatePDFDocumentFile(true);
                            if (boxMail.isSelected()) {
                                sheet.createDocument();
                                String mail = selectedClient.getString("MAIL");
                                try {
                                    EmailComposer.getInstance().compose(mail, "", "", pdf);
                                }
                                catch (Exception exn) {
                                    ExceptionHandler.handle(null, "Impossible de cr\u00e9er le courriel", exn);
                                }
                            } else {
                                FileUtils.openFile(pdf);
                            }
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Une erreur est survenue lors de la cr\u00e9ation du document", e);
                        }
                    }
                }.start();
            }
        });
        ++c.gridy;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        this.add((Component)buttonValid, c);
        buttonValid.setEnabled(false);
        box.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                buttonValid.setEnabled(box.getWantedID() != -1 && box.getWantedID() != box.getRequest().getPrimaryTable().getUndefinedID());
            }
        });
    }
}

