/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplate;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.GestionDevise;

public class MailRelanceCreator {
    private final EmailTemplate template;
    private final List<SQLRow> rowEcheances;
    private final Map<String, String> map;

    public MailRelanceCreator(EmailTemplate template, List<SQLRow> row) {
        if (template == null) {
            template = new EmailTemplate("default", this.getDefaultObject(), this.getDefaultValue(row.size() > 1), true, "dd/MM/yyyy");
        }
        this.template = template;
        this.rowEcheances = row;
        Integer client = null;
        for (SQLRow sqlRow : row) {
            if (client == null) {
                client = sqlRow.getForeignID("ID_CLIENT");
                continue;
            }
            if (client.intValue() == sqlRow.getForeignID("ID_CLIENT")) continue;
            throw new IllegalArgumentException("Plusieurs clients pour la relance par mail.");
        }
        this.map = this.getMapValues();
    }

    public String getDefaultObject() {
        return "Relance {FactureNumero}";
    }

    public String getDefaultValue(boolean multiple) {
        String value = !multiple ? "Bonjour,\n\nSauf erreur de notre part, votre compte laisse appara\u00eetre dans nos livres un montant de {FactureRestant}\u20ac non r\u00e9gl\u00e9 \u00e0 ce jour.\nCe montant correspond \u00e0 la facture {FactureNumero} dat\u00e9e du {FactureDate} qui a pour \u00e9ch\u00e9ance le {FactureDateEcheance}.\nNous pr\u00e9sumons qu'il s'agit d'un simple oubli de votre part.\n\nToutefois, si le paiement avait \u00e9t\u00e9 effectu\u00e9, nous vous serions tr\u00e8s oblig\u00e9s de nous en communiquer la date et le mode de r\u00e8glement.\n\nDans l'attente d\u2019un prompt r\u00e8glement,\n\nNous vous prions d'agr\u00e9er, Madame, Monsieur, l'expression de nos sentiments distingu\u00e9s." : "Bonjour,\n\nSauf erreur de notre part, votre compte laisse appara\u00eetre dans nos livres un montant de {FactureRestant}\u20ac non r\u00e9gl\u00e9 \u00e0 ce jour.\nCe montant correspond aux factures :\n{FacturesDetails}\nNous pr\u00e9sumons qu'il s'agit d'un simple oubli de votre part.\n\nToutefois, si le paiement avait \u00e9t\u00e9 effectu\u00e9, nous vous serions tr\u00e8s oblig\u00e9s de nous en communiquer la date et le mode de r\u00e8glement.\n\nDans l'attente d\u2019un prompt r\u00e8glement,\n\nNous vous prions d'agr\u00e9er, Madame, Monsieur, l'expression de nos sentiments distingu\u00e9s.";
        return value;
    }

    private Map<String, String> getMapValues() {
        SQLRow clientRowNX;
        String datePattern = this.template.getDateFormat();
        if (datePattern == null || datePattern.trim().isEmpty()) {
            datePattern = "dd/MM/yyyy";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        SQLRow rowSoc = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowSocAdresse = rowSoc.getForeignRow("ID_ADRESSE_COMMON");
        SQLRow rowUser = rowSoc.getTable().getDBRoot().findTable("USER_COMMON").getRow(UserManager.getUser().getId());
        map.put("UserName", rowUser.getString("NOM"));
        map.put("UserFirstName", rowUser.getString("PRENOM"));
        if (rowUser.getTable().contains("MAIL")) {
            map.put("UserMail", rowUser.getString("MAIL"));
        }
        if (rowUser.getTable().contains("TEL")) {
            map.put("UserTel", rowUser.getString("TEL"));
        }
        map.put("SocieteType", rowSoc.getString("TYPE"));
        map.put("SocieteNom", rowSoc.getString("NOM"));
        map.put("SocieteAdresse", rowSocAdresse.getString("RUE"));
        map.put("SocieteCodePostal", rowSocAdresse.getString("CODE_POSTAL"));
        String ville = rowSocAdresse.getString("VILLE");
        Object cedex = rowSocAdresse.getObject("CEDEX");
        boolean hasCedex = rowSocAdresse.getBoolean("HAS_CEDEX");
        if (hasCedex) {
            ville = String.valueOf(ville) + " CEDEX";
            if (cedex != null && cedex.toString().trim().length() > 0) {
                ville = String.valueOf(ville) + " " + cedex.toString().trim();
            }
        }
        map.put("SocieteVille", ville);
        SQLRow rowClient = clientRowNX = this.rowEcheances.get(0).getForeignRow("ID_CLIENT");
        SQLRow rowAdresse = rowClient.getForeignRow("ID_ADRESSE");
        if (!clientRowNX.isForeignEmpty("ID_ADRESSE_F")) {
            rowAdresse = clientRowNX.getForeign("ID_ADRESSE_F");
        }
        SQLRow rowCompteClient = clientRowNX.getForeignRow("ID_COMPTE_PCE");
        String numero = rowCompteClient.getString("NUMERO");
        map.put("ClientNumeroCompte", numero);
        map.put("ClientType", rowClient.getString("FORME_JURIDIQUE"));
        map.put("ClientNom", rowClient.getString("NOM"));
        map.put("ClientAdresse", rowAdresse.getString("RUE"));
        map.put("ClientCodePostal", rowAdresse.getString("CODE_POSTAL"));
        String villeCli = rowAdresse.getString("VILLE");
        Object cedexCli = rowAdresse.getObject("CEDEX");
        boolean hasCedexCli = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        map.put("ClientVille", villeCli);
        Date d = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        map.put("RelanceDate", dateFormat.format(d));
        Long lTotal = 0L;
        Long lRestant = 0L;
        Long lVerse = 0L;
        HashSet<String> facturesNumero = new HashSet<String>();
        HashSet<String> facturesRef = new HashSet<String>();
        HashSet<String> facturesDate = new HashSet<String>();
        HashSet<String> facturesDetails = new HashSet<String>();
        for (SQLRow sqlRow : this.rowEcheances) {
            SQLRow foreign = sqlRow.getForeign("ID_SAISIE_VENTE_FACTURE");
            lTotal = lTotal + (Long)foreign.getObject("T_TTC");
            lRestant = lRestant + (Long)sqlRow.getObject("MONTANT");
            lVerse = lVerse + Long.valueOf(lTotal - lRestant);
            facturesDetails.add(String.valueOf(foreign.getString("NUMERO")) + " du " + dateFormat.format(foreign.getDate("DATE").getTime()) + " d'un montant TTC : " + GestionDevise.currencyToString((Long)foreign.getObject("T_TTC"), true) + "\u20ac, restant \u00e0 r\u00e9gler " + GestionDevise.currencyToString((Long)sqlRow.getObject("MONTANT"), true) + "\u20ac \u00e9ch\u00e9ance le " + dateFormat.format(sqlRow.getDate("DATE").getTime()));
            Date dFacture = (Date)foreign.getObject("DATE");
            SQLRow modeRegRow = foreign.getForeignRow("ID_MODE_REGLEMENT");
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), dFacture);
            map.put("FactureDateEcheance", dateFormat.format(dateEch));
            facturesNumero.add(foreign.getString("NUMERO"));
            facturesRef.add(foreign.getString("NOM"));
            facturesDate.add(dateFormat.format((Date)foreign.getObject("DATE")));
        }
        map.put("FactureNumero", CollectionUtils.join(facturesNumero, ","));
        map.put("FactureReference", CollectionUtils.join(facturesRef, ","));
        map.put("FactureDate", CollectionUtils.join(facturesDate, ","));
        map.put("FacturesDetails", CollectionUtils.join(facturesDetails, "\n"));
        map.put("FactureTotal", GestionDevise.currencyToString(lTotal, true));
        map.put("FactureRestant", GestionDevise.currencyToString(lRestant, true));
        map.put("FactureVerse", GestionDevise.currencyToString(lVerse, true));
        map.put("message", "");
        return map;
    }

    public String getObject() {
        return this.fill(this.template.getTitle());
    }

    public String getValue() {
        return this.fill(this.template.getText());
    }

    private String fill(String string) {
        String result = string;
        for (String key : this.map.keySet()) {
            result = result.replace("{" + key + "}", this.map.get(key));
        }
        return result;
    }
}

