/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.ExceptionHandler;

public class UpdateCommEchFrame
extends JFrame {
    private JTextField numero = new JTextField();
    private JTextField client = new JTextField(30);
    private ITextArea comm = new ITextArea(5, 50);
    SQLRow row;

    public static UpdateCommEchFrame getFrame() {
        UpdateCommEchFrame frame = new UpdateCommEchFrame();
        frame.pack();
        frame.setLocationRelativeTo(null);
        return frame;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        panel.add((Component)new JLabel("Facture"), c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.numero, c);
        this.numero.setEditable(false);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Client"), c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.client, c);
        this.client.setEditable(false);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Commentaires"), c);
        ++c.gridx;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)this.comm, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.anchor = 10;
        c.fill = 0;
        JButton apply = new JButton("Valider");
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    try {
                        UpdateCommEchFrame.this.update();
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("Une erreur est survenue lors de la mise \u00e0 jour des commentaires!", e1);
                        UpdateCommEchFrame.this.dispose();
                    }
                }
                finally {
                    UpdateCommEchFrame.this.dispose();
                }
            }
        });
        panel.add((Component)apply, c);
        return panel;
    }

    public UpdateCommEchFrame() {
        super("Modification des commentaires");
        this.getContentPane().add(this.createPanel());
    }

    public void select(SQLRow row) {
        this.row = row;
        if (row == null) {
            this.comm.setText("");
            this.numero.setText("");
            this.client.setText("");
            return;
        }
        this.comm.setText(row.getString("INFOS"));
        this.numero.setText(row.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").getString("NOM"));
        this.client.setText(row.getForeign("ID_CLIENT").getString("NOM"));
    }

    private void update() throws SQLException {
        if (this.row != null) {
            SQLRowValues rowValues = this.row.createEmptyUpdateRow();
            rowValues.put("INFOS", this.comm.getText());
            rowValues.update();
        }
    }
}

