/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.action;

import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;

public class ListeDesFacturesPrevisionnellesOCAction
extends CreateFrameAbstractAction {
    private IListFrame listFrame;

    public ListeDesFacturesPrevisionnellesOCAction() {
        this.putValue("Name", "Liste des factures pr\u00e9visionnelles");
    }

    public JFrame createFrame() {
        SQLElement eltFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        Where wPrev = new Where((FieldRef)eltFacture.getTable().getField("PREVISIONNELLE"), "=", (Object)Boolean.TRUE);
        final ListeAddPanel listPanel = new ListeAddPanel(eltFacture, new IListe(eltFacture.createTableSource(wPrev))){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                SQLRow row = this.getElement().getTable().getRow(this.getListe().getSelectedId());
                if (row != null && row.getID() > 1) {
                    SQLRow mvt = row.getForeign("ID_MOUVEMENT");
                    if (source == this.buttonEffacer) {
                        super.handleAction(source, evt);
                    } else if (source == this.buttonModifier) {
                        EditFrame editModifyFrame = this.element.getTable().getName().equals("SAISIE_VENTE_FACTURE") && row.getBoolean("PARTIAL") != false ? new EditFrame(this.element.createComponent("sales.invoice.partial.future"), EditPanel.MODIFICATION) : (this.element.getTable().getName().equals("SAISIE_VENTE_FACTURE") && row.getBoolean("SOLDE") != false ? new EditFrame(this.element.createComponent("sales.invoice.partial.balance.future"), EditPanel.MODIFICATION) : new EditFrame(this.element, EditPanel.MODIFICATION));
                        editModifyFrame.selectionId(this.getListe().getSelectedId());
                        editModifyFrame.setVisible(true);
                        editModifyFrame.getPanel().disableDelete();
                    } else {
                        super.handleAction(source, evt);
                    }
                } else {
                    super.handleAction(source, evt);
                }
            }
        };
        listPanel.setAddVisible(false);
        this.listFrame = new IListFrame(listPanel){

            @Override
            public void setTitle() {
                int count;
                String title = "Liste des factures pr\u00e9visionnelles";
                int rowCount = listPanel.getListe().getRowCount();
                title = String.valueOf(title) + ", " + this.getPlural("ligne", rowCount);
                int total = listPanel.getListe().getTotalRowCount();
                if (total != rowCount) {
                    title = String.valueOf(title) + " / " + total;
                }
                if ((count = listPanel.getListe().getItemCount()) >= 0) {
                    title = String.valueOf(title) + ", " + this.getPlural("\u00e9l\u00e9ment", count);
                }
                this.setTitle(title);
            }
        };
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Transf\u00e9rer en facture"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLElement eltFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                SQLRowValues rowVals = IListe.get(e).fetchSelectedRow().asRowValues();
                SQLComponent comp = rowVals.getBoolean("PARTIAL") != false ? eltFacture.createComponent("sales.invoice.partial") : (rowVals.getBoolean("SOLDE") != false ? eltFacture.createComponent("sales.invoice.partial.balance") : eltFacture.createComponent("default component code"));
                EditFrame frameTransfert = new EditFrame(comp, EditFrame.MODIFICATION);
                frameTransfert.setTitle("Transfert en facture");
                rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLElement.class, new Date()));
                rowVals.put("DATE", new Date());
                rowVals.put("PREVISIONNELLE", Boolean.FALSE);
                comp.select(rowVals);
                frameTransfert.setVisible(true);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.listFrame.getPanel().getListe().addIListeAction(action);
        return this.listFrame;
    }
}

