/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.reports.history.ui;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.reports.history.ui.ListeHistoriquePanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.JListSQLTablePanel;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class HistoriqueArticleFrame {
    private PanelFrame panelFrame;
    private ListeHistoriquePanel listPanel;

    public HistoriqueArticleFrame(SQLElement articleElt) {
        HashMap<String, List<String>> mapList = new HashMap<String, List<String>>();
        mapList.put("Propos\u00e9s", Arrays.asList("DEVIS_ELEMENT"));
        mapList.put("Command\u00e9s (clients)", Arrays.asList("COMMANDE_CLIENT_ELEMENT"));
        mapList.put("Livr\u00e9s", Arrays.asList("BON_DE_LIVRAISON_ELEMENT"));
        mapList.put("Factur\u00e9s", Arrays.asList("SAISIE_VENTE_FACTURE_ELEMENT"));
        mapList.put("Command\u00e9s (fournisseurs)", Arrays.asList("COMMANDE_ELEMENT"));
        this.listPanel = new ListeHistoriquePanel("Articles", JListSQLTablePanel.createComboRequest(articleElt, true), mapList, null, null, null);
        int i = 0;
        while (i < 4) {
            IListPanel panel = this.listPanel.getListePanel(i);
            SQLTable primaryTable = panel.getListe().getSource().getPrimaryTable();
            ArrayList<SQLField> asList = new ArrayList<SQLField>();
            asList.add(primaryTable.getField("QTE"));
            if (primaryTable.contains("T_PV_HT")) {
                asList.add(primaryTable.getField("T_PV_HT"));
            } else {
                asList.add(primaryTable.getField("T_PA_HT"));
            }
            IListTotalPanel totalPanel = new IListTotalPanel(panel.getListe(), asList);
            DefaultGridBagConstraints c = new DefaultGridBagConstraints();
            c.gridy += 2;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = 13;
            panel.add((Component)totalPanel, c);
            ++i;
        }
        this.panelFrame = new PanelFrame(this.listPanel, "Historique client");
        this.panelFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HistoriqueArticleFrame.this.listPanel.removeAllTableListener();
            }
        });
        this.panelFrame.setDefaultCloseOperation(2);
    }

    public PanelFrame getFrame() {
        return this.panelFrame;
    }

    public void selectId(int id) {
        this.listPanel.selectIDinJList(id);
    }

    public void setVisible(boolean b) {
        this.panelFrame.setVisible(b);
    }
}

