/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.SQLJavaEditor;
import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.RubriqueSQLComponent;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableTree;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NoneSelectedButtonGroup;

public class RubriqueBrutSQLElement
extends ComptaSQLConfElement {
    public RubriqueBrutSQLElement(DBRoot root) {
        super(root.getTable("RUBRIQUE_BRUT"), "une rubrique de brut", "rubriques de brut");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("BASE");
        l.add("TAUX");
        l.add("MONTANT");
        l.add("COTISABLE");
        l.add("PART_CP");
        l.add("TAXABLE_CM");
        l.add("CSG_NORMAL");
        l.add("CSG_REDUIT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    @Override
    public SQLComponent createComponent() {
        return new RubriqueSQLComponent(this){
            private SQLJavaEditor formuleBase;
            private SQLJavaEditor formuleTaux;
            private SQLJavaEditor formuleMontant;

            @Override
            protected void addViews(GridBagConstraints c) {
                c.weightx = 0.0;
                c.gridwidth = 1;
                JPanel panelCalcul = new JPanel();
                panelCalcul.setLayout(new GridBagLayout());
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                final VariableTree tree = new VariableTree();
                JScrollPane paneTree = new JScrollPane(tree);
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.weightx = 1.0;
                cPanel.fill = 1;
                cPanel.fill = 2;
                cPanel.weighty = 0.0;
                cPanel.weightx = 0.0;
                cPanel.gridheight = 1;
                ++cPanel.gridx;
                Map<String, List<?>> mapTree = VariablePayeSQLElement.getMapTree();
                this.formuleBase = new SQLJavaEditor(mapTree);
                this.formuleBase.setVarAssign("BASE");
                final JRadioButton radioBase = new JRadioButton(this.getLabelFor("BASE"));
                panelCalcul.add((Component)radioBase, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleBase), cPanel);
                JSeparator sep1 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep1, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleTaux = new SQLJavaEditor(mapTree);
                this.formuleTaux.setVarAssign("TAUX");
                JRadioButton radioTaux = new JRadioButton(this.getLabelFor("TAUX"));
                panelCalcul.add((Component)radioTaux, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleTaux), cPanel);
                JSeparator sep2 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep2, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleMontant = new SQLJavaEditor(mapTree);
                this.formuleMontant.setVarAssign("MONTANT");
                final JRadioButton radioMontant = new JRadioButton(this.getLabelFor("MONTANT"));
                panelCalcul.add((Component)radioMontant, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleMontant), cPanel);
                JSeparator sep3 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep3, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                JLabel labelSelSal = new JLabel("Salari\u00e9");
                labelSelSal.setHorizontalAlignment(4);
                panelCalcul.add((Component)labelSelSal, cPanel);
                SalarieSQLElement eltSal = this.getDirectory().getElement(SalarieSQLElement.class);
                final ElementComboBox selSalarie = new ElementComboBox(false);
                ++cPanel.gridx;
                selSalarie.init(eltSal);
                panelCalcul.add((Component)selSalarie, cPanel);
                ButtonGroup groupRadio = new ButtonGroup();
                groupRadio.add(radioBase);
                groupRadio.add(radioMontant);
                groupRadio.add(radioTaux);
                radioBase.setSelected(true);
                tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && e.getButton() == 1) {
                            TreePath path = tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                            Object obj = path.getLastPathComponent();
                            if (obj == null) {
                                return;
                            }
                            if (obj instanceof FormuleTreeNode) {
                                FormuleTreeNode n = (FormuleTreeNode)obj;
                                if (radioBase.isSelected()) {
                                    int start = formuleBase.getSelectionStart();
                                    String tmp = formuleBase.getText();
                                    formuleBase.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioMontant.isSelected()) {
                                    int start = formuleMontant.getSelectionStart();
                                    String tmp = formuleMontant.getText();
                                    formuleMontant.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else {
                                    int start = formuleTaux.getSelectionStart();
                                    String tmp = formuleTaux.getText();
                                    formuleTaux.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                }
                            }
                        }
                    }
                });
                JPanel panelProp = new JPanel();
                panelProp.setLayout(new GridBagLayout());
                cPanel.gridx = 0;
                cPanel.gridy = 0;
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridwidth = 1;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                cPanel.anchor = 18;
                cPanel.insets = new Insets(2, 2, 1, 2);
                this.addView("ID_PERIODE_VALIDITE", "required;notdecorated;noseparator");
                ElementSQLObject eltInfosPaye = (ElementSQLObject)this.getView("ID_PERIODE_VALIDITE");
                cPanel.gridy = 0;
                cPanel.gridx = 0;
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.fill = 0;
                JPanel panelPeriodeVal = new JPanel();
                panelPeriodeVal.setBorder(BorderFactory.createTitledBorder("P\u00e9riode de validit\u00e9"));
                panelPeriodeVal.add(eltInfosPaye);
                panelProp.add((Component)panelPeriodeVal, cPanel);
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                JLabel labelSelTypeRubrique = new JLabel("Type");
                labelSelTypeRubrique.setHorizontalAlignment(4);
                ++cPanel.gridx;
                cPanel.gridheight = 1;
                cPanel.weightx = 0.0;
                cPanel.anchor = 17;
                panelProp.add((Component)labelSelTypeRubrique, cPanel);
                SQLRequestComboBox comboSelTypeRubrique = new SQLRequestComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeRubrique, cPanel);
                JLabel labelSelTypeRubriqueImpression = new JLabel("Impression");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypeRubriqueImpression, cPanel);
                SQLRequestComboBox comboSelTypeImpression = new SQLRequestComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeImpression, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkImpo = new JCheckBox(this.getLabelFor("TAXABLE_CM"));
                panelProp.add((Component)checkImpo, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkCotis = new JCheckBox(this.getLabelFor("COTISABLE"));
                panelProp.add((Component)checkCotis, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkBrut = new JCheckBox(this.getLabelFor("PART_BRUT"));
                panelProp.add((Component)checkBrut, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkBrutHSExo = new JCheckBox(this.getLabelFor("HEURE_SUP_EXO"));
                panelProp.add((Component)checkBrutHSExo, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkCP = new JCheckBox(this.getLabelFor("PART_CP"));
                panelProp.add((Component)checkCP, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkCSGN = new JCheckBox(this.getLabelFor("CSG_NORMAL"));
                panelProp.add((Component)checkCSGN, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkCSGR = new JCheckBox(this.getLabelFor("CSG_REDUIT"));
                panelProp.add((Component)checkCSGR, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkCSGSansAbattement = new JCheckBox(this.getLabelFor("PART_CSG_SANS_ABATTEMENT"));
                panelProp.add((Component)checkCSGSansAbattement, cPanel);
                NoneSelectedButtonGroup groupCSG = new NoneSelectedButtonGroup();
                groupCSG.add(checkCSGN);
                groupCSG.add(checkCSGR);
                groupCSG.add(checkCSGSansAbattement);
                JLabel labelSelCodeRubrique = new JLabel("Code DSN (S21.G00.51.011)");
                labelSelCodeRubrique.setHorizontalAlignment(4);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.gridheight = 1;
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                cPanel.anchor = 17;
                panelProp.add((Component)labelSelCodeRubrique, cPanel);
                ElementComboBox comboSelCodeRubrique = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelCodeRubrique, cPanel);
                this.addView(comboSelCodeRubrique, "ID_CODE_TYPE_RUBRIQUE_BRUT");
                JTabbedPane tab = new JTabbedPane();
                tab.add("Calcul", new JSplitPane(1, paneTree, panelCalcul));
                tab.add("Propri\u00e9t\u00e9s", panelProp);
                c.gridwidth = 0;
                c.gridx = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)tab, c);
                this.addSQLObject((JComponent)((Object)this.formuleBase), "BASE");
                this.addSQLObject((JComponent)((Object)this.formuleTaux), "TAUX");
                this.addSQLObject((JComponent)((Object)this.formuleMontant), "MONTANT");
                this.addRequiredSQLObject(comboSelTypeRubrique, "ID_TYPE_RUBRIQUE_BRUT");
                this.addRequiredSQLObject(comboSelTypeImpression, "ID_IMPRESSION_RUBRIQUE");
                this.addSQLObject(checkBrut, "PART_BRUT");
                this.addSQLObject(checkBrutHSExo, "HEURE_SUP_EXO");
                this.addSQLObject(checkCotis, "COTISABLE");
                this.addSQLObject(checkCP, "PART_CP");
                this.addSQLObject(checkImpo, "TAXABLE_CM");
                this.addSQLObject(checkCSGN, "CSG_NORMAL");
                this.addSQLObject(checkCSGR, "CSG_REDUIT");
                this.addSQLObject(checkCSGSansAbattement, "PART_CSG_SANS_ABATTEMENT");
                selSalarie.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        formuleBase.setSalarieID(selSalarie.getSelectedId());
                        formuleTaux.setSalarieID(selSalarie.getSelectedId());
                        formuleMontant.setSalarieID(selSalarie.getSelectedId());
                    }
                });
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("TAXABLE_CM", Boolean.TRUE);
                rowVals.put("COTISABLE", Boolean.TRUE);
                rowVals.put("PART_BRUT", Boolean.TRUE);
                rowVals.put("CSG_NORMAL", Boolean.TRUE);
                return rowVals;
            }
        };
    }

    @Override
    protected String createCode() {
        return "humanresources.payroll.category.raw";
    }
}

