/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.humanresources.payroll.ui.AyantDroitTable;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ListMap;

public class AyantDroitSQLElement
extends ComptaSQLConfElement {
    public AyantDroitSQLElement() {
        super("AYANT_DROIT", "un ayant droit", "ayants droit");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SALARIE");
        l.add("NOM");
        l.add("PRENOMS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("PRENOMS");
        return l;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".ayantdroit";
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            AyantDroitTable table;
            {
                this.table = new AyantDroitTable();
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JPanel panelInfos = new JPanel();
                panelInfos.setBorder(BorderFactory.createTitledBorder("Renseignements (S21.G00.73)"));
                panelInfos.setLayout(new GridBagLayout());
                JLabel labelSal = new JLabel(this.getLabelFor("ID_SALARIE"));
                SQLRequestComboBox boxSal = new SQLRequestComboBox();
                panelInfos.add((Component)labelSal, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)boxSal, c);
                this.addRequiredSQLObject(boxSal, "ID_SALARIE");
                c.weightx = 0.0;
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                JTextField textNom = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelInfos.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textNom, c);
                this.addRequiredSQLObject(textNom, "NOM");
                c.weightx = 0.0;
                JLabel labelPrenoms = new JLabel(this.getLabelFor("PRENOMS"));
                JTextField textPrenoms = new JTextField();
                ++c.gridx;
                panelInfos.add((Component)labelPrenoms, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textPrenoms, c);
                this.addRequiredSQLObject(textPrenoms, "PRENOMS");
                c.weightx = 0.0;
                JLabel labelCO = new JLabel(this.getLabelFor("CODE_OPTION"));
                JTextField textCO = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelInfos.add((Component)labelCO, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)textCO, c);
                this.addSQLObject(textCO, "CODE_OPTION");
                c.weightx = 0.0;
                JLabel labelADT = new JLabel(this.getLabelFor("ID_AYANT_DROIT_TYPE"));
                SQLRequestComboBox boxType = new SQLRequestComboBox();
                ++c.gridx;
                panelInfos.add((Component)labelADT, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)boxType, c);
                this.addRequiredSQLObject(boxType, "ID_AYANT_DROIT_TYPE");
                JLabel labelD = new JLabel(this.getLabelFor("DATE_DEBUT_RATTACHEMENT"));
                JDate d = new JDate();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelInfos.add((Component)labelD, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)d, c);
                this.addRequiredSQLObject(d, "DATE_DEBUT_RATTACHEMENT");
                c.weightx = 0.0;
                JLabel labelDN = new JLabel(this.getLabelFor("DATE_NAISSANCE"));
                JDate dn = new JDate();
                ++c.gridx;
                panelInfos.add((Component)labelDN, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)dn, c);
                this.addRequiredSQLObject(dn, "DATE_NAISSANCE");
                JLabel labelNIR = new JLabel(this.getLabelFor("NIR"));
                JTextField nir = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelInfos.add((Component)labelNIR, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)nir, c);
                this.addSQLObject(nir, "NIR");
                c.weightx = 0.0;
                JLabel labelCodeAffil = new JLabel(this.getLabelFor("CODE_ORGANISME_AFFILIATION"));
                JTextField codeAffil = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelInfos.add((Component)labelCodeAffil, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)codeAffil, c);
                this.addSQLObject(codeAffil, "CODE_ORGANISME_AFFILIATION");
                c.weightx = 0.0;
                JLabel labelDATEFIN = new JLabel(this.getLabelFor("DATE_FIN_RATTACHEMENT"));
                JDate dFin = new JDate();
                ++c.gridx;
                panelInfos.add((Component)labelDATEFIN, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelInfos.add((Component)dFin, c);
                this.addRequiredSQLObject(dFin, "DATE_FIN_RATTACHEMENT");
                c.weightx = 0.0;
                c.gridx = 0;
                ++c.gridy;
                c.fill = 1;
                c.gridwidth = 0;
                c.weighty = 1.0;
                panelInfos.add((Component)this.table, c);
                c.gridx = 0;
                ++c.gridy;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)panelInfos, c);
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                this.table.updateField("ID_AYANT_DROIT", id);
                return id;
            }

            @Override
            public void update() {
                int id = this.getSelectedID();
                super.update();
                this.table.updateField("ID_AYANT_DROIT", id);
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.table.insertFrom("ID_AYANT_DROIT", r.getID());
                }
            }
        };
    }
}

