/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.component;

import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.sql.model.SQLRow;

public class VariableRowTreeNode
extends FormuleTreeNode {
    private SQLRow row;
    private String label;

    public VariableRowTreeNode(SQLRow row) {
        this.row = row;
        this.setLabelFromRow();
    }

    private void setLabelFromRow() {
        this.label = "";
        if (this.row != null) {
            this.label = this.row.contains("CODE") ? String.valueOf(this.row.getString("CODE")) + " - " + this.row.getString("NOM") : this.row.getString("NOM");
        }
    }

    public String getName() {
        return this.label;
    }

    @Override
    public String toString() {
        return this.label;
    }

    @Override
    public String getTextValue() {
        return this.label;
    }

    @Override
    public String getTextInfosValue() {
        return this.row == null ? "" : this.row.getString("INFOS");
    }

    public SQLRow getRow() {
        return this.row;
    }

    public void setRow(SQLRow row) {
        this.row = row;
        this.setLabelFromRow();
    }

    public int getID() {
        return this.row == null ? 1 : this.row.getID();
    }
}

