/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.tax.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.element.TaxeCatComptableSQLElement;
import org.openconcerto.erp.core.sales.product.ui.TaxeCategorieComptableTable;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ProductInfo;

public class TaxeSQLElement
extends ComptaSQLConfElement {
    public TaxeSQLElement() {
        super("TAXE", "une taxe", "taxes");
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9finir par d\u00e9faut"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLRowValues row = IListe.get(e).getSelectedRow();
                final SQLDataSource ds = row.getTable().getDBSystemRoot().getDataSource();
                try {
                    SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                        @Override
                        public Object create() throws SQLException {
                            UpdateBuilder upRemoveDefault = new UpdateBuilder(row.getTable());
                            upRemoveDefault.set("DEFAULT", "FALSE");
                            ds.execute(upRemoveDefault.asString());
                            UpdateBuilder upSetDefault = new UpdateBuilder(row.getTable());
                            upSetDefault.set("DEFAULT", "TRUE");
                            upSetDefault.setWhere(new Where((FieldRef)row.getTable().getKey(), "=", row.getID()));
                            ds.execute(upSetDefault.asString());
                            JOptionPane.showMessageDialog(null, "R\u00e9d\u00e9marrez " + ProductInfo.getInstance().getName() + " pour valider le changement de TVA par d\u00e9faut.");
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Erreur lors d'affectation de la nouvelle TVA par d\u00e9faut", ex);
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("TAUX");
        l.add("DEFAULT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            TaxeCategorieComptableTable tableCatComptable;
            {
                this.tableCatComptable = new TaxeCategorieComptableTable(this.getElement().getDirectory().getElement(TaxeCatComptableSQLElement.class));
            }

            @Override
            protected void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"), 4);
                this.add((Component)labelNom, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.fill = 0;
                JTextField fieldNom = new JTextField(40);
                DefaultGridBagConstraints.lockMinimumSize(fieldNom);
                this.add((Component)fieldNom, c);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.fill = 2;
                JLabel labelTaux = new JLabel(this.getLabelFor("TAUX"), 4);
                this.add((Component)labelTaux, c);
                ++c.gridx;
                c.fill = 0;
                JTextField fieldTaux = new JTextField(6);
                DefaultGridBagConstraints.lockMinimumSize(fieldTaux);
                this.add((Component)fieldTaux, c);
                JLabel labelCompteCol = new JLabel(this.getLabelFor("ID_COMPTE_PCE_COLLECTE"), 4);
                c.fill = 2;
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)labelCompteCol, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                ISQLCompteSelector compteCol = new ISQLCompteSelector();
                this.add((Component)compteCol, c);
                JLabel labelCompteDed = new JLabel(this.getLabelFor("ID_COMPTE_PCE_DED"), 4);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.gridwidth = 1;
                c.fill = 2;
                this.add((Component)labelCompteDed, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                ISQLCompteSelector compteDed = new ISQLCompteSelector();
                this.add((Component)compteDed, c);
                JLabel labelCompteVente = new JLabel(this.getLabelFor("ID_COMPTE_PCE_VENTE"), 4);
                c.fill = 2;
                c.gridwidth = 1;
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)labelCompteVente, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                ISQLCompteSelector compteVente = new ISQLCompteSelector();
                this.add((Component)compteVente, c);
                JLabel labelCompteVenteS = new JLabel(this.getLabelFor("ID_COMPTE_PCE_VENTE_SERVICE"), 4);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.gridwidth = 1;
                c.fill = 2;
                this.add((Component)labelCompteVenteS, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                ISQLCompteSelector compteVenteS = new ISQLCompteSelector();
                this.add((Component)compteVenteS, c);
                JLabel labelCompteColIntra = new JLabel(this.getLabelFor("ID_COMPTE_PCE_COLLECTE_INTRA"), 4);
                c.fill = 2;
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 1;
                c.weightx = 0.0;
                this.add((Component)labelCompteColIntra, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                ISQLCompteSelector compteColIntra = new ISQLCompteSelector();
                this.add((Component)compteColIntra, c);
                JLabel labelCompteDedIntra = new JLabel(this.getLabelFor("ID_COMPTE_PCE_DED_INTRA"), 4);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.gridwidth = 1;
                c.fill = 2;
                this.add((Component)labelCompteDedIntra, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                ISQLCompteSelector compteDedIntra = new ISQLCompteSelector();
                this.add((Component)compteDedIntra, c);
                ++c.gridy;
                c.gridx = 0;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.fill = 1;
                c.gridwidth = 0;
                this.add((Component)this.createCategorieComptablePanel(), c);
                this.addSQLObject((JComponent)compteCol, "ID_COMPTE_PCE_COLLECTE");
                this.addSQLObject((JComponent)compteDed, "ID_COMPTE_PCE_DED");
                this.addSQLObject((JComponent)compteVente, "ID_COMPTE_PCE_VENTE");
                this.addSQLObject((JComponent)compteVenteS, "ID_COMPTE_PCE_VENTE_SERVICE");
                this.addSQLObject((JComponent)compteColIntra, "ID_COMPTE_PCE_COLLECTE_INTRA");
                this.addSQLObject((JComponent)compteDedIntra, "ID_COMPTE_PCE_DED_INTRA");
                this.addRequiredSQLObject(fieldNom, "NOM");
                this.addRequiredSQLObject(fieldTaux, "TAUX");
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.tableCatComptable.getRowValuesTable().insertFrom(r);
                }
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                this.tableCatComptable.updateField("ID_TAXE", id);
                return id;
            }

            @Override
            public void update() {
                super.update();
                this.tableCatComptable.updateField("ID_TAXE", this.getSelectedID());
            }

            protected JPanel createCategorieComptablePanel() {
                JPanel panel = new JPanel(new GridBagLayout());
                panel.setOpaque(false);
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.gridwidth = 1;
                c.weightx = 0.0;
                ++c.gridy;
                c.gridx = 0;
                panel.add((Component)new JLabel("Ajouter la cat\u00e9gorie "), c);
                final ElementComboBox boxCat = new ElementComboBox();
                boxCat.init(this.getDirectory().getElement("CATEGORIE_COMPTABLE"));
                ++c.gridx;
                panel.add((Component)boxCat, c);
                c.fill = 0;
                ++c.gridx;
                JButton buttonAjouter = new JButton("Ajouter");
                buttonAjouter.setOpaque(false);
                panel.add((Component)buttonAjouter, c);
                ++c.gridx;
                JButton buttonSupprimer = new JButton("Supprimer");
                buttonSupprimer.setOpaque(false);
                panel.add((Component)buttonSupprimer, c);
                c.gridwidth = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                ++c.gridy;
                c.gridx = 0;
                c.fill = 1;
                this.tableCatComptable.setOpaque(false);
                panel.add((Component)this.tableCatComptable, c);
                buttonAjouter.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLRow rowCat = boxCat.getSelectedRow();
                        if (rowCat == null || rowCat.isUndefined()) {
                            return;
                        }
                        int nbRows = tableCatComptable.getModel().getRowCount();
                        int i = 0;
                        while (i < nbRows) {
                            SQLRowValues rowVals = tableCatComptable.getModel().getRowValuesAt(i);
                            int idTarif = Integer.parseInt(rowVals.getObject("ID_CATEGORIE_COMPTABLE").toString());
                            if (idTarif == rowCat.getID()) {
                                JOptionPane.showMessageDialog(null, "Impossible d'ajouter.\nLa cat\u00e9gorie est d\u00e9j\u00e0 pr\u00e9sente dans la liste!");
                                return;
                            }
                            ++i;
                        }
                        SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("TAXE_CATEGORIE_COMPTABLE"));
                        if (this.getSelectedID() > 1) {
                            rowVals.put("ID_TAXE", this.getSelectedID());
                        }
                        rowVals.put("ID_CATEGORIE_COMPTABLE", rowCat.getID());
                        tableCatComptable.getModel().addRow(rowVals);
                    }
                });
                buttonSupprimer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        tableCatComptable.removeSelectedRow();
                    }
                });
                return panel;
            }
        };
    }

    @Override
    protected String createCode() {
        return "finance.tax";
    }
}

