/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.KeyTableCellRenderer;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.TimestampTableCellEditor;

public class DepotChequeTable
extends JPanel {
    protected RowValuesTable table;
    protected SQLTableElement montant;
    protected RowValuesTableModel model;

    public DepotChequeTable() {
        this.init();
        this.uiInit();
    }

    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement tableElement_Chq = new SQLTableElement(e.getTable().getField("ID_CHEQUE_A_ENCAISSER"), Integer.class, new DefaultCellEditor(new JTextField()));
        tableElement_Chq.setRenderer(new KeyTableCellRenderer(e.getForeignElement("ID_CHEQUE_A_ENCAISSER")));
        list.add(tableElement_Chq);
        SQLTableElement tableElement_Client = new SQLTableElement(e.getTable().getField("ID_CLIENT"), Integer.class, new DefaultCellEditor(new JTextField()));
        tableElement_Client.setRenderer(new KeyTableCellRenderer(e.getForeignElement("ID_CLIENT")));
        list.add(tableElement_Client);
        SQLTableElement tiersElement = new SQLTableElement(e.getTable().getField("TIERS"));
        list.add(tiersElement);
        SQLTableElement numeroElement = new SQLTableElement(e.getTable().getField("NUMERO"));
        list.add(numeroElement);
        SQLTableElement banqueElement = new SQLTableElement(e.getTable().getField("BANQUE"));
        list.add(banqueElement);
        SQLTableElement pieceElement = new SQLTableElement(e.getTable().getField("PIECE"));
        list.add(pieceElement);
        SQLTableElement dateElement = new SQLTableElement(e.getTable().getField("DATE"), Timestamp.class, new TimestampTableCellEditor());
        list.add(dateElement);
        this.montant = new SQLTableElement(e.getTable().getField("MONTANT"), Long.class, new DeviseCellEditor());
        this.montant.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.montant);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("MONTANT"), false);
        this.table = new RowValuesTable(this.model, null, true);
        this.table.setEditable(false);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("DEPOT_CHEQUE_ELEMENT");
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public void insertFrom(SQLRowValues rowVals) {
        this.table.insertFrom(rowVals);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getMontantElement() {
        return this.montant;
    }

    public void refreshTable() {
        this.table.repaint();
    }
}

