/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.payment.element.ReglerMontantSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.CollectionUtils;

public class ReglerMontantSQLElement
extends ComptaSQLConfElement {
    public ReglerMontantSQLElement() {
        super("REGLER_MONTANT", "un r\u00e8glement \u00e0 un fournisseur", "r\u00e8glements aux fournisseurs");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("ID_FOURNISSEUR");
        l.add("ID_MODE_REGLEMENT");
        l.add("MONTANT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT");
        return l;
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        BaseSQLTableModelColumn racColFact = new BaseSQLTableModelColumn("Factures associ\u00e9es", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                Collection<? extends SQLRowAccessor> l = r.getReferentRows(r.getTable().getTable("REGLER_MONTANT_ELEMENT"));
                String s = "";
                for (SQLRowAccessor sQLRowAccessor : l) {
                    SQLRowAccessor rMvt;
                    if (sQLRowAccessor.isForeignEmpty("ID_MOUVEMENT_ECHEANCE") || (rMvt = sQLRowAccessor.getForeign("ID_MOUVEMENT_ECHEANCE")).isForeignEmpty("ID_PIECE")) continue;
                    SQLRowAccessor rP = rMvt.getForeign("ID_PIECE");
                    s = String.valueOf(s) + (s.trim().length() > 0 ? ", " : "") + rP.getString("NOM");
                }
                return s;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ReglerMontantSQLElement.this.getTable());
                Path p2 = (Path)p.add(p.getLast().getTable("REGLER_MONTANT_ELEMENT"));
                Path p3 = (Path)p2.add(p2.getLast().getField("ID_MOUVEMENT_ECHEANCE"));
                Path p4 = (Path)p3.add(p3.getLast().getField("ID_PIECE"));
                return CollectionUtils.createSet(new FieldPath(p4, "NOM"));
            }
        };
        res.getColumns().add(racColFact);
        BaseSQLTableModelColumn racCol = new BaseSQLTableModelColumn("Report \u00e9ch\u00e9ance", Boolean.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return r.getForeign("ID_MODE_REGLEMENT").getBoolean("COMPTANT") == false;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ReglerMontantSQLElement.this.getTable());
                Path p2 = (Path)p.add(p.getLast().getField("ID_MODE_REGLEMENT"));
                return CollectionUtils.createSet(new FieldPath(p2, "COMPTANT"));
            }
        };
        res.getColumns().add(racCol);
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            for (SQLRow rowRegleItem : row.getReferentRows(row.getTable().getTable("REGLER_MONTANT_ELEMENT").getField("ID_REGLER_MONTANT"))) {
                SQLRow rowEch = rowRegleItem.getForeignRow("ID_ECHEANCE_FOURNISSEUR");
                if (rowEch.getID() > 1) {
                    SQLRowValues rowVals = rowEch.createEmptyUpdateRow();
                    rowVals.put("REGLE", Boolean.FALSE);
                    if (rowEch.getBoolean("REGLE").booleanValue()) {
                        rowVals.put("MONTANT", rowRegleItem.getLong("MONTANT_REGLE"));
                    } else {
                        rowVals.put("MONTANT", rowEch.getLong("MONTANT") + rowRegleItem.getLong("MONTANT_REGLE"));
                    }
                    rowVals.update();
                }
                this.getDirectory().getElement(rowRegleItem.getTable()).archive(rowRegleItem);
            }
            SQLSelect sel = new SQLSelect(this.getTable().getBase());
            SQLTable tableMvt = this.getTable().getTable("MOUVEMENT");
            EcritureSQLElement eltEcr = (EcritureSQLElement)this.getDirectory().getElement(tableMvt.getTable("ECRITURE"));
            sel.addSelectStar(tableMvt);
            Where w = new Where((FieldRef)tableMvt.getField("SOURCE"), "=", (Object)this.getTable().getName());
            w = w.and(new Where((FieldRef)tableMvt.getField("IDSOURCE"), "=", row.getID()));
            sel.setWhere(w);
            List list = (List)this.getTable().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, tableMvt));
            for (SQLRow sqlRow : list) {
                eltEcr.archiveMouvementProfondeur(sqlRow.getID(), true);
            }
        }
        super.archive(trees, cutLinks);
    }

    @Override
    public SQLComponent createComponent() {
        return new ReglerMontantSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".regulation";
    }
}

