/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLRow;

public class DepotChequeElementSQLElement
extends ComptaSQLConfElement {
    public DepotChequeElementSQLElement() {
        super("DEPOT_CHEQUE_ELEMENT", "un ch\u00e9que d\u00e9pos\u00e9", "ch\u00e8ques d\u00e9pos\u00e9s");
    }

    @Override
    protected String getParentFFName() {
        return "ID_DEPOT_CHEQUE";
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addView("DATE");
            }
        };
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            if (row.getObject("ID_CHEQUE_A_ENCAISSER") == null || row.isForeignEmpty("ID_CHEQUE_A_ENCAISSER")) continue;
            row.getForeign("ID_CHEQUE_A_ENCAISSER").createEmptyUpdateRow().put("ENCAISSE", Boolean.FALSE).commit();
        }
        super.archive(trees, cutLinks);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".depot.item";
    }
}

