/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.payment.ui.DepotChequeTable;
import org.openconcerto.erp.generationEcritures.GenerationMvtDepotChequeClient;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public class DepotChequeSQLComponent
extends BaseSQLComponent {
    private DepotChequeTable table = new DepotChequeTable();
    private JTextField nom = new JTextField();
    private DeviseField montant = new DeviseField(10);
    private JDate date;
    private ElementComboBox boxBanque = new ElementComboBox(true);

    public DepotChequeSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)new JLabelBold("Ch\u00e8ques"), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.table, c);
        this.table.getRowValuesTable().setEnabled(false);
        c.fill = 2;
        c.gridwidth = 1;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        String itemName = "ID_" + this.getDirectory().getElement(BanqueSQLElement.class).getTable().getName();
        this.add((Component)new JLabel(this.getLabelFor(itemName), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.add((Component)this.boxBanque, c);
        c.gridwidth = 1;
        this.date = new JDate(true);
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Date"), c);
        c.weightx = 0.0;
        this.add((Component)this.date, c);
        this.addSQLObject(this.boxBanque, itemName);
        ++c.gridy;
        c.gridx = 0;
        JLabel label = new JLabel(this.getLabelFor("NOM"), 4);
        c.weightx = 0.0;
        this.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)this.nom, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Montant encaiss\u00e9", 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 0;
        this.add((Component)this.montant, c);
        this.addRequiredSQLObject(this.date, "DATE");
        this.addRequiredSQLObject(this.montant, "MONTANT");
        this.addSQLObject(this.nom, "NOM");
        DefaultGridBagConstraints.lockMinimumSize(this.montant);
        TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RowValuesTableModel model = DepotChequeSQLComponent.this.table.getRowValuesTable().getRowValuesTableModel();
                if (e.getColumn() == -1 || e.getColumn() == model.getColumnIndexForElement(DepotChequeSQLComponent.this.table.getMontantElement())) {
                    int rowCount = model.getRowCount();
                    long total = 0L;
                    int i = 0;
                    while (i < rowCount) {
                        Number nHT = (Number)model.getValueAt(i, model.getColumnIndexForElement(DepotChequeSQLComponent.this.table.getMontantElement()));
                        if (nHT != null) {
                            total += nHT.longValue();
                        }
                        ++i;
                    }
                    DepotChequeSQLComponent.this.montant.setText(GestionDevise.currencyToString(total));
                }
            }
        };
        this.table.getRowValuesTable().getRowValuesTableModel().addTableModelListener(tableListener);
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null && r.getID() > 1) {
            this.table.insertFrom("ID_DEPOT_CHEQUE", r.getID());
        } else if (r != null && r instanceof SQLRowValues) {
            this.table.insertFrom((SQLRowValues)r);
        }
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        try {
            this.table.updateField("ID_DEPOT_CHEQUE", id);
            System.err.println("G\u00e9n\u00e9ration des ecritures du reglement");
            GenerationMvtDepotChequeClient depotGen = new GenerationMvtDepotChequeClient(this.getTable().getRow(id));
            depotGen.genere();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des ecritures du reglement", e);
        }
        return id;
    }

    @Override
    public void update() {
        int id = this.getSelectedID();
        super.update();
        this.table.updateField("ID_DEPOT_CHEQUE", id);
        SQLRow row = this.getTable().getRow(id);
        int idMvt = row.getInt("ID_MOUVEMENT");
        try {
            EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
            eltEcr.archiveMouvementProfondeur(idMvt, false);
            GenerationMvtDepotChequeClient depotGen = new GenerationMvtDepotChequeClient(row);
            depotGen.genere();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected SQLRowValues createDefaults() {
        this.table.getModel().clearRows();
        return new SQLRowValues(this.getTable());
    }
}

