/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.cc.ITransformer;

public class ListeEcritureParClassePanel
extends JPanel {
    public ListeEcritureParClassePanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JTabbedPane tabbedClasseCpt = new JTabbedPane();
        for (ClasseCompte cc : ClasseCompte.getClasseCompte()) {
            JScrollPane scrollPane = new JScrollPane(this.createIListe(cc));
            scrollPane.setOpaque(false);
            scrollPane.setBorder(null);
            scrollPane.getViewport().setOpaque(false);
            tabbedClasseCpt.addTab(cc.getNom(), scrollPane);
        }
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)tabbedClasseCpt, c);
    }

    private ListeAddPanel createIListe(final ClasseCompte ccTmp) {
        final SQLElement elementEcriture = Configuration.getInstance().getDirectory().getElement("ECRITURE");
        SQLTableModelSourceOnline src = elementEcriture.getTableSource(true);
        src.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                String function = "REGEXP";
                String match = ccTmp.getTypeNumeroCompte();
                if (elementEcriture.getTable().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
                    function = "~";
                }
                Where w = new Where(sel.getAlias(elementEcriture.getTable().getField("COMPTE_NUMERO")), function, (Object)match);
                if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
                    w = w.and(new Where((FieldRef)elementEcriture.getTable().getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
                }
                return sel.andWhere(w);
            }
        });
        final ListeAddPanel panel = new ListeAddPanel(elementEcriture, new IListe(src));
        panel.setOpaque(false);
        panel.setSearchFullMode(true);
        JTable table = panel.getListe().getJTable();
        panel.setCloneVisible(false);
        panel.setAddVisible(false);
        panel.setModifyVisible(false);
        panel.setReloadVisible(true);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    menuDroit.add(new AbstractAction("Contrepassation"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EcritureSQLElement.contrePassationPiece(panel.getListe().getSelectedId());
                        }
                    });
                    menuDroit.add(new AbstractAction("Voir la source"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SQLRow row = panel.getListe().fetchSelectedRow();
                            MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
                        }
                    });
                    menuDroit.show(event.getComponent(), event.getPoint().x, event.getPoint().y);
                }
            }
        });
        panel.getListe().getModel().invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = panel.getListe().getModel().getRowCount() - 1;
                if (rowCount > 0) {
                    panel.getListe().getJTable().setRowSelectionInterval(rowCount, rowCount);
                }
            }
        });
        return panel;
    }
}

