/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SelectionJournalImportPanel;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public class ImportEcriturePanel
extends JPanel {
    private final Map<String, Integer> mapJournal = new HashMap<String, Integer>();
    private final Map<String, Integer> mapCompte = new HashMap<String, Integer>();

    public ImportEcriturePanel() {
        super(new GridBagLayout());
        JLabel label = new JLabel("Import depuis un fichier CSV, XLS ou ODT.");
        JLabel label2 = new JLabel("Le fichier doit contenir les colonnes :");
        JLabel label3 = new JLabel(" - Date dd/MM/yyyy");
        JLabel label4 = new JLabel(" - Journal");
        JLabel label5 = new JLabel(" - N\u00b0 de compte");
        JLabel label6 = new JLabel(" - Nom de la pi\u00e8ce");
        JLabel label7 = new JLabel(" - Libell\u00e9");
        JLabel label8 = new JLabel(" - D\u00e9bit");
        JLabel label9 = new JLabel(" - Cr\u00e9dit");
        final JButton button = new JButton("S\u00e9lectionner le ficher");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 2;
        this.add((Component)label, c);
        ++c.gridy;
        this.add((Component)label2, c);
        ++c.gridy;
        this.add((Component)label3, c);
        ++c.gridy;
        this.add((Component)label4, c);
        ++c.gridy;
        this.add((Component)label5, c);
        ++c.gridy;
        this.add((Component)label6, c);
        ++c.gridy;
        this.add((Component)label7, c);
        ++c.gridy;
        this.add((Component)label8, c);
        ++c.gridy;
        this.add((Component)label9, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        final ReloadPanel rlPanel = new ReloadPanel();
        c.anchor = 13;
        c.fill = 0;
        this.add((Component)rlPanel, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)button, c);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.setEnabled(false);
                final Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, ImportEcriturePanel.this);
                final FileDialog fd = new FileDialog(frame, "Import d'\u00e9critures", 0);
                fd.setVisible(true);
                rlPanel.setMode(0);
                if (fd.getFile() != null) {
                    new Thread(){

                        @Override
                        public void run() {
                            File fileToImport = new File(fd.getDirectory(), fd.getFile());
                            try {
                                final ArrayTableModel model = ImportEcriturePanel.this.loadData(fileToImport);
                                try {
                                    final DBRoot rootSociete = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getRootSociete();
                                    SQLUtils.executeAtomic(rootSociete.getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                                        @Override
                                        public Object handle(SQLDataSource ds) throws SQLException, IOException {
                                            try {
                                                try {
                                                    SQLSelect sel = new SQLSelect();
                                                    sel.addSelectStar(rootSociete.getTable("JOURNAL"));
                                                    List<SQLRow> rowsJrnl = SQLRowListRSH.execute(sel);
                                                    for (SQLRow sqlRow : rowsJrnl) {
                                                        ImportEcriturePanel.this.mapJournal.put(sqlRow.getString("CODE"), sqlRow.getID());
                                                    }
                                                    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                                                    String mouvementName = "Import " + format.format(new Date());
                                                    SQLBackgroundTableCache.getInstance().getCacheForTable(rootSociete.getTable("COMPTE_PCE")).setEnableReloadIfTableModified(false);
                                                    boolean ok = ImportEcriturePanel.this.importTableModel(model, mouvementName, frame, true);
                                                    if (ok) {
                                                        ImportEcriturePanel.this.importTableModel(model, mouvementName, frame, false);
                                                        SwingUtilities.invokeLater(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                JOptionPane.showMessageDialog(null, "Importation des \u00e9critures termin\u00e9e");
                                                            }
                                                        });
                                                    }
                                                }
                                                catch (Exception exn) {
                                                    ExceptionHandler.handle("Erreur pendant l'importation", exn);
                                                    SQLBackgroundTableCache.getInstance().getCacheForTable(rootSociete.getTable("COMPTE_PCE")).setEnableReloadIfTableModified(true);
                                                }
                                            }
                                            finally {
                                                SQLBackgroundTableCache.getInstance().getCacheForTable(rootSociete.getTable("COMPTE_PCE")).setEnableReloadIfTableModified(true);
                                            }
                                            return null;
                                        }
                                    });
                                }
                                catch (Exception exn) {
                                    ExceptionHandler.handle(frame, "Erreur lors de l'insertion dans la base", exn);
                                }
                            }
                            catch (Exception e) {
                                if (e.getMessage() != null && e.getMessage().toLowerCase().contains("file format")) {
                                    JOptionPane.showMessageDialog(ImportEcriturePanel.this, "Format de fichier non pris en charge");
                                }
                                ExceptionHandler.handle(frame, "Erreur lors de la lecture du fichier " + fileToImport.getAbsolutePath(), e);
                            }
                            frame.dispose();
                        }
                    }.start();
                }
            }
        });
    }

    public ArrayTableModel loadData(File f) throws IOException {
        DataImporter importer = new DataImporter();
        importer.setSkipFirstLine(false);
        return importer.createModelFrom(f);
    }

    public boolean importTableModel(ArrayTableModel m, String mvtName, final Frame owner, boolean dryRun) throws Exception {
        SimpleDateFormat dF = new SimpleDateFormat("dd/MM/yyyy");
        GenerationEcritures gen = new GenerationEcritures();
        int idMvt = -1;
        if (!dryRun) {
            idMvt = gen.getNewMouvement("", 1, 1, mvtName);
        }
        long soldeGlobal = 0L;
        String dateOrigin = null;
        int rowCount = m.getRowCount();
        int i = 0;
        while (i < rowCount) {
            String stringPiece;
            String trim;
            int column;
            block15: {
                column = 0;
                try {
                    Date dateValue;
                    Object firstValue = m.getValueAt(i, column);
                    if (firstValue == null) break;
                    if (firstValue.getClass().isAssignableFrom(Date.class)) {
                        dateValue = (Date)firstValue;
                    } else {
                        if (firstValue.toString().trim().isEmpty()) break;
                        dateValue = dF.parse(firstValue.toString());
                    }
                    final String dateStringValue = dF.format(dateValue);
                    if (dateOrigin == null) {
                        dateOrigin = dateStringValue;
                    }
                    gen.putValue("DATE", dateValue);
                    ++column;
                    if (dateOrigin.equals(dateStringValue)) break block15;
                    dateOrigin = dateStringValue;
                    if (!dryRun) {
                        idMvt = gen.getNewMouvement("", 1, 1, mvtName);
                        break block15;
                    }
                    if (soldeGlobal == 0L) break block15;
                    final double soldeMvt = (double)soldeGlobal / 100.0;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Le mouvement du " + dateStringValue + " ne respecte pas la partie double (Solde du mouvement : " + soldeMvt + ")!\nImport annul\u00e9!");
                        }
                    });
                    return false;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Donn\u00e9e invalide sur la ligne " + (i + 1) + " , colonne " + (column + 1), e);
                }
            }
            final String valueJrnl = m.getValueAt(i, column).toString();
            if (!dryRun && this.mapJournal.get(valueJrnl) == null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JDialog diag = new JDialog(owner);
                        diag.setModal(true);
                        diag.setContentPane(new SelectionJournalImportPanel(valueJrnl, ImportEcriturePanel.this.mapJournal, null));
                        diag.setTitle("Import d'\u00e9critures");
                        diag.setLocationRelativeTo(null);
                        diag.pack();
                        diag.setVisible(true);
                    }
                });
            }
            gen.putValue("ID_JOURNAL", this.mapJournal.get(valueJrnl));
            String numCompt = trim = m.getValueAt(i, ++column).toString().trim();
            if (trim.contains(".")) {
                numCompt = trim.substring(0, trim.indexOf(46));
            }
            numCompt = numCompt.trim();
            if (!dryRun) {
                int idCpt = this.getOrCreateCompte(numCompt);
                gen.putValue("ID_COMPTE_PCE", idCpt);
            }
            if ((stringPiece = m.getValueAt(i, ++column).toString()) != null && stringPiece.length() > 0 && stringPiece.contains(".")) {
                stringPiece = stringPiece.substring(0, stringPiece.indexOf(46));
            }
            gen.putValue("NOM", String.valueOf(m.getValueAt(i, ++column).toString()) + " " + stringPiece);
            String stringValueD = m.getValueAt(i, ++column).toString();
            long montantD = GestionDevise.parseLongCurrency(stringValueD);
            String stringValueC = m.getValueAt(i, ++column).toString();
            long montantC = GestionDevise.parseLongCurrency(stringValueC);
            gen.putValue("CREDIT", montantC);
            gen.putValue("DEBIT", montantD);
            soldeGlobal += montantD;
            soldeGlobal -= montantC;
            gen.putValue("ID_MOUVEMENT", idMvt);
            gen.putValue("NOM", String.valueOf(m.getValueAt(i, 4).toString()) + " " + stringPiece);
            if (!dryRun) {
                gen.ajoutEcriture();
            }
            ++i;
        }
        if (soldeGlobal != 0L) {
            throw new IllegalArgumentException("La partie double n'est respect\u00e9e (solde = " + soldeGlobal + "). Import annul\u00e9!");
        }
        return true;
    }

    private int getOrCreateCompte(String numeroCompte) {
        if (this.mapCompte.containsKey(numeroCompte)) {
            return this.mapCompte.get(numeroCompte);
        }
        int id = ComptePCESQLElement.getId(numeroCompte);
        this.mapCompte.put(numeroCompte, id);
        return id;
    }
}

