/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;

public class CompteGestCommPreferencePanel
extends DefaultPreferencePanel {
    private ISQLCompteSelector selCompteCBAttente;
    private ISQLCompteSelector selCompteTVAIntraComm;
    private ISQLCompteSelector selCompteFourn;
    private ISQLCompteSelector selCompteAchat;
    private ISQLCompteSelector selCompteValeurEncaissement;
    private ISQLCompteSelector selCompteAvanceClient;
    private ISQLCompteSelector selCompteClient;
    private ISQLCompteSelector selCompteVenteProduits;
    private ISQLCompteSelector selCompteVenteService;
    private ISQLCompteSelector selCompteTVACol;
    private ISQLCompteSelector selCompteTVADed;
    private ISQLCompteSelector selCompteTVAImmo;
    private ISQLCompteSelector selCompteAchatIntra;
    private ISQLCompteSelector selCompteFactor;
    private ISQLCompteSelector selComptePortSoumis;
    private ISQLCompteSelector selComptePortNonSoumis;
    private ISQLCompteSelector selComptePortNonSoumisAchat;
    private ISQLCompteSelector selComptePortSoumisAchat;
    private ElementComboBox selJrnlFactor;
    private ElementComboBox selJrnlValEnc;
    private ElementComboBox selJrnlCB;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private SQLRowValues rowPrefCompteVals = new SQLRowValues(tablePrefCompte);

    public CompteGestCommPreferencePanel() {
        SQLRow rowPrefCompte = tablePrefCompte.getRow(2);
        this.rowPrefCompteVals.loadAbsolutelyAll(rowPrefCompte);
        Insets separatorInsets = new Insets(10, 2, 1, 2);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        Insets normalInsets = c.insets;
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        TitledSeparator sep = new TitledSeparator("Saisie des Achats");
        c.gridwidth = 0;
        this.add((Component)sep, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte Fournisseur"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteFourn = new ISQLCompteSelector();
        this.selCompteFourn.init();
        this.add((Component)this.selCompteFourn, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte Achat"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteAchat = new ISQLCompteSelector();
        this.selCompteAchat.init();
        this.add((Component)this.selCompteAchat, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte Achat Intracommunautaire"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteAchatIntra = new ISQLCompteSelector();
        this.selCompteAchatIntra.init();
        this.add((Component)this.selCompteAchatIntra, c);
        ++c.gridy;
        c.gridx = 0;
        TitledSeparator sepPortAchat = new TitledSeparator("Ports sur achat");
        c.insets = separatorInsets;
        c.gridwidth = 0;
        this.add((Component)sepPortAchat, c);
        c.insets = normalInsets;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte Port soumis \u00e0 TVA"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selComptePortSoumisAchat = new ISQLCompteSelector();
        this.selComptePortSoumisAchat.init();
        this.add((Component)this.selComptePortSoumisAchat, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte Port non soumis \u00e0 TVA"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selComptePortNonSoumisAchat = new ISQLCompteSelector();
        this.selComptePortNonSoumisAchat.init();
        this.add((Component)this.selComptePortNonSoumisAchat, c);
        ++c.gridy;
        c.gridx = 0;
        TitledSeparator sepVenteC = new TitledSeparator("Saisie des ventes");
        c.gridwidth = 0;
        c.insets = separatorInsets;
        this.add((Component)sepVenteC, c);
        c.insets = normalInsets;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte Client"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteClient = new ISQLCompteSelector();
        this.selCompteClient.init();
        this.add((Component)this.selCompteClient, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte Avance Client"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteAvanceClient = new ISQLCompteSelector();
        this.selCompteAvanceClient.init();
        this.add((Component)this.selCompteAvanceClient, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte d\u00e9p\u00f4t ch\u00e8que"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteValeurEncaissement = new ISQLCompteSelector();
        this.selCompteValeurEncaissement.init();
        this.add((Component)this.selCompteValeurEncaissement, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Journal d\u00e9p\u00f4t ch\u00e8que"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selJrnlValEnc = new ElementComboBox();
        this.selJrnlValEnc.init(Configuration.getInstance().getDirectory().getElement("JOURNAL"));
        this.add((Component)this.selJrnlValEnc, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Journal CB Attente"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selJrnlCB = new ElementComboBox();
        this.selJrnlCB.init(Configuration.getInstance().getDirectory().getElement("JOURNAL"));
        this.add((Component)this.selJrnlCB, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte CB Attente"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteCBAttente = new ISQLCompteSelector();
        this.selCompteCBAttente.init();
        this.add((Component)this.selCompteCBAttente, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte Vente de produits"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteVenteProduits = new ISQLCompteSelector();
        this.selCompteVenteProduits.init();
        this.add((Component)this.selCompteVenteProduits, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte Vente de service"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteVenteService = new ISQLCompteSelector();
        this.selCompteVenteService.init();
        this.add((Component)this.selCompteVenteService, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte affacturage"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteFactor = new ISQLCompteSelector();
        this.selCompteFactor.init();
        this.add((Component)this.selCompteFactor, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Journal affacturage"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selJrnlFactor = new ElementComboBox();
        this.selJrnlFactor.init(Configuration.getInstance().getDirectory().getElement("JOURNAL"));
        this.add((Component)this.selJrnlFactor, c);
        ++c.gridy;
        c.gridx = 0;
        TitledSeparator sepPort = new TitledSeparator("Ports sur vente");
        c.insets = separatorInsets;
        c.gridwidth = 0;
        this.add((Component)sepPort, c);
        c.insets = normalInsets;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte Port soumis \u00e0 TVA"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selComptePortSoumis = new ISQLCompteSelector();
        this.selComptePortSoumis.init();
        this.add((Component)this.selComptePortSoumis, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte Port non soumis \u00e0 TVA"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selComptePortNonSoumis = new ISQLCompteSelector();
        this.selComptePortNonSoumis.init();
        this.add((Component)this.selComptePortNonSoumis, c);
        ++c.gridy;
        c.gridx = 0;
        TitledSeparator sepTVA = new TitledSeparator("TVA");
        c.insets = separatorInsets;
        c.gridwidth = 0;
        this.add((Component)sepTVA, c);
        c.insets = normalInsets;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte TVA Collect\u00e9e (Ventes)"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteTVACol = new ISQLCompteSelector();
        this.selCompteTVACol.init();
        this.add((Component)this.selCompteTVACol, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte TVA d\u00e9ductible (Achats)"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteTVADed = new ISQLCompteSelector();
        this.selCompteTVADed.init();
        this.add((Component)this.selCompteTVADed, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte TVA due intracommunautaire"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteTVAIntraComm = new ISQLCompteSelector();
        this.selCompteTVAIntraComm.init();
        this.add((Component)this.selCompteTVAIntraComm, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte TVA sur immobilisations"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteTVAImmo = new ISQLCompteSelector();
        this.selCompteTVAImmo.init();
        this.add((Component)this.selCompteTVAImmo, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)new JPanel(), c);
        this.setValues();
    }

    @Override
    public void storeValues() {
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_ACHAT", this.selCompteAchat.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_ACHAT_INTRA", this.selCompteAchatIntra.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_VENTE_PRODUIT", this.selCompteVenteProduits.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_VENTE_SERVICE", this.selCompteVenteService.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_FACTOR", this.selCompteFactor.getValue());
        int selectedId = this.selJrnlFactor.getSelectedId();
        this.rowPrefCompteVals.put("ID_JOURNAL_FACTOR", selectedId > 1 ? selectedId : 1);
        int selectedIdEnc = this.selJrnlValEnc.getSelectedId();
        this.rowPrefCompteVals.put("ID_JOURNAL_VALEUR_ENCAISSEMENT", selectedIdEnc > 1 ? selectedIdEnc : 1);
        int selectedIdCB = this.selJrnlCB.getSelectedId();
        this.rowPrefCompteVals.put("ID_JOURNAL_CB_ATTENTE", selectedIdCB > 1 ? selectedIdCB : 1);
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_CB_ATTENTE", this.selCompteCBAttente.getSelectedId() > 1 ? this.selCompteCBAttente.getSelectedId() : 1);
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_FOURNISSEUR", this.selCompteFourn.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_CLIENT", this.selCompteClient.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_AVANCE_CLIENT", this.selCompteAvanceClient.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_VALEUR_ENCAISSEMENT", this.selCompteValeurEncaissement.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_TVA_ACHAT", this.selCompteTVADed.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_TVA_VENTE", this.selCompteTVACol.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_TVA_INTRA", this.selCompteTVAIntraComm.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_TVA_IMMO", this.selCompteTVAImmo.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_PORT_SOUMIS", this.selComptePortSoumis.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_PORT_NON_SOUMIS", this.selComptePortNonSoumis.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_PORT_SOUMIS_ACHAT", this.selComptePortSoumisAchat.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_PORT_NON_SOUMIS_ACHAT", this.selComptePortNonSoumisAchat.getValue());
        try {
            Object[] pb = this.rowPrefCompteVals.getInvalid();
            if (pb != null) {
                SQLFieldTranslator trans = Configuration.getInstance().getTranslator();
                JOptionPane.showMessageDialog(SwingUtilities.getRoot(this), "Impossible de valider les modifications! Le champ <" + trans.getLabelFor(this.rowPrefCompteVals.getTable().getField(pb[0].toString())) + "> pointe sur un compte invalide!(" + pb[1] + ")");
            } else {
                this.rowPrefCompteVals.update();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void restoreToDefaults() {
        try {
            String compte = ComptePCESQLElement.getComptePceDefault("Achats");
            int value = ComptePCESQLElement.getId(compte);
            this.selCompteAchat.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("AchatsIntra");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteAchatIntra.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("VentesProduits");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteVenteProduits.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("VentesServices");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteVenteService.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("Factor");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteFactor.setValue(value);
            this.selJrnlFactor.setValue(GenerationMvtSaisieVenteFacture.journal);
            this.selJrnlValEnc.setValue(4);
            compte = ComptePCESQLElement.getComptePceDefault("Fournisseurs");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteFourn.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("Clients");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteClient.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("AvanceClients");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteAvanceClient.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("ValeurEncaissement");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteValeurEncaissement.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("PortVenteSoumisTVA");
            value = ComptePCESQLElement.getId(compte);
            this.selComptePortSoumis.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("PortVenteNonSoumisTVA");
            value = ComptePCESQLElement.getId(compte);
            this.selComptePortNonSoumis.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("PortAchatSoumisTVA");
            value = ComptePCESQLElement.getId(compte);
            this.selComptePortSoumisAchat.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("PortAchatNonSoumisTVA");
            value = ComptePCESQLElement.getId(compte);
            this.selComptePortNonSoumisAchat.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("TVACollectee");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteTVACol.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("TVADeductible");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteTVADed.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("TVAIntraComm");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteTVAIntraComm.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("TVAImmo");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteTVAImmo.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTitleName() {
        return "Gestion commerciale";
    }

    private void setValues() {
        try {
            int valueCpt;
            int value;
            this.setComboValues(this.selCompteAchat, "ID_COMPTE_PCE_ACHAT", "Achats");
            this.setComboValues(this.selCompteAchatIntra, "ID_COMPTE_PCE_ACHAT_INTRA", "AchatsIntra");
            this.setComboValues(this.selCompteVenteProduits, "ID_COMPTE_PCE_VENTE_PRODUIT", "VentesProduits");
            this.setComboValues(this.selCompteVenteService, "ID_COMPTE_PCE_VENTE_SERVICE", "VentesServices");
            this.setComboValues(this.selCompteFactor, "ID_COMPTE_PCE_FACTOR", "Factor");
            int n = value = this.rowPrefCompteVals.getObject("ID_JOURNAL_FACTOR") == null ? 1 : this.rowPrefCompteVals.getInt("ID_JOURNAL_FACTOR");
            if (value <= 1) {
                value = GenerationMvtSaisieVenteFacture.journal;
            }
            this.selJrnlFactor.setValue(value);
            int n2 = value = this.rowPrefCompteVals.getObject("ID_JOURNAL_CB_ATTENTE") == null ? 1 : this.rowPrefCompteVals.getInt("ID_JOURNAL_CB_ATTENTE");
            if (value > 1) {
                this.selJrnlCB.setValue(value);
            }
            int n3 = valueCpt = this.rowPrefCompteVals.getObject("ID_COMPTE_PCE_CB_ATTENTE") == null ? 1 : this.rowPrefCompteVals.getInt("ID_COMPTE_PCE_CB_ATTENTE");
            if (valueCpt > 1) {
                this.selCompteCBAttente.setValue(valueCpt);
            }
            int n4 = value = this.rowPrefCompteVals.getObject("ID_JOURNAL_VALEUR_ENCAISSEMENT") == null ? 1 : this.rowPrefCompteVals.getInt("ID_JOURNAL_VALEUR_ENCAISSEMENT");
            if (value <= 1) {
                value = 4;
            }
            this.selJrnlValEnc.setValue(value);
            this.setComboValues(this.selCompteFourn, "ID_COMPTE_PCE_FOURNISSEUR", "Fournisseurs");
            this.setComboValues(this.selCompteClient, "ID_COMPTE_PCE_CLIENT", "Clients");
            this.setComboValues(this.selCompteAvanceClient, "ID_COMPTE_PCE_AVANCE_CLIENT", "AvanceClients");
            this.setComboValues(this.selCompteValeurEncaissement, "ID_COMPTE_PCE_VALEUR_ENCAISSEMENT", "ValeurEncaissement");
            this.setComboValues(this.selComptePortSoumis, "ID_COMPTE_PCE_PORT_SOUMIS", "PortVenteSoumisTVA");
            this.setComboValues(this.selComptePortNonSoumis, "ID_COMPTE_PCE_PORT_NON_SOUMIS", "PortVenteNonSoumisTVA");
            this.setComboValues(this.selComptePortSoumisAchat, "ID_COMPTE_PCE_PORT_SOUMIS_ACHAT", "PortAchatSoumisTVA");
            this.setComboValues(this.selComptePortNonSoumisAchat, "ID_COMPTE_PCE_PORT_NON_SOUMIS_ACHAT", "PortAchatNonSoumisTVA");
            this.setComboValues(this.selCompteTVACol, "ID_COMPTE_PCE_TVA_VENTE", "TVACollectee");
            this.setComboValues(this.selCompteTVADed, "ID_COMPTE_PCE_TVA_ACHAT", "TVADeductible");
            this.setComboValues(this.selCompteTVAIntraComm, "ID_COMPTE_PCE_TVA_INTRA", "TVAIntraComm");
            this.setComboValues(this.selCompteTVAImmo, "ID_COMPTE_PCE_TVA_IMMO", "TVAImmo");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setComboValues(ISQLCompteSelector combo, String field, String defaultName) {
        int value = 1;
        SQLRowAccessor row = this.rowPrefCompteVals.getForeign(field);
        if (row == null || row.isUndefined()) {
            String compte = ComptePCESQLElement.getComptePceDefault(defaultName);
            value = ComptePCESQLElement.getId(compte);
        } else {
            value = row.getID();
        }
        combo.setValue(value);
    }
}

