/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.BalanceAgeeListeSheetXML;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;

public class BalanceAgeePanel
extends JPanel {
    public BalanceAgeePanel() {
        super(new GridBagLayout());
        JLabel label = new JLabel("Balance \u00e2g\u00e9e client pour la p\u00e9riode du ");
        SQLRow rowExercice = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete().getForeignRow("ID_EXERCICE_COMMON");
        Calendar dDebut = rowExercice.getDate("DATE_DEB");
        final JDate dateDeb = new JDate();
        dateDeb.setDate(dDebut.getTime());
        final JDate dateFin = new JDate(true);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        this.add((Component)label, c);
        this.add((Component)dateDeb, c);
        this.add((Component)new JLabel("au"), c);
        this.add((Component)dateFin, c);
        c.gridy = c.gridy + 1;
        c.gridx = 0;
        c.gridwidth = 0;
        final JCheckBox boxExcludeEcr = new JCheckBox("Exclure les \u00e9critures de clotures");
        boxExcludeEcr.setSelected(true);
        this.add((Component)boxExcludeEcr, c);
        c.gridy = c.gridy + 1;
        c.gridwidth = 0;
        c.anchor = 13;
        c.fill = 0;
        JButton gen = new JButton("Cr\u00e9er");
        this.add((Component)gen, c);
        gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BalanceAgeeListeSheetXML l = new BalanceAgeeListeSheetXML(dateDeb.getDate(), dateFin.getDate(), boxExcludeEcr.isSelected());
                try {
                    l.createDocument();
                    l.openDocument(false);
                }
                catch (Exception originalExn) {
                    ExceptionHandler.handle("Impossible de cr\u00e9er la balance \u00e2g\u00e9e", originalExn);
                }
            }
        });
    }
}

