/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Vector;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.finance.accounting.ui.DeviseKmRowValuesRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.utils.DecimalUtils;

public class AssociationAnalytiqueItemKDModel {
    private final DeviseKmRowValuesRenderer deviseRenderer = new DeviseKmRowValuesRenderer();
    private final DeviseCellEditor deviseCellEditor = new DeviseCellEditor();
    RowValuesTableModel model;

    public AssociationAnalytiqueItemKDModel() {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE");
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTable tableElement = elt.getTable();
        SQLTableElement tableElementNomCompte = new SQLTableElement(tableElement.getField("ID_POSTE_ANALYTIQUE"));
        list.add(tableElementNomCompte);
        final SQLTableElement tableElementPourcent = new SQLTableElement(tableElement.getField("POURCENT"));
        list.add(tableElementPourcent);
        SQLTableElement tableElementMontant = new SQLTableElement(tableElement.getField("MONTANT"), Long.class, this.deviseCellEditor);
        list.add(tableElementMontant);
        SQLRowValues rowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(tableElement));
        rowVals.put("POURCENT", BigDecimal.ONE.movePointRight(2));
        this.model = new RowValuesTableModel(elt, list, tableElement.getField("ID_POSTE_ANALYTIQUE"), false, rowVals);
        tableElementMontant.addModificationListener(tableElementPourcent);
        tableElementPourcent.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                long montant = row.getLong("MONTANT");
                long total = row.getForeign("ID_ECRITURE").getLong("DEBIT") - row.getForeign("ID_ECRITURE").getLong("CREDIT");
                BigDecimal pourcent = BigDecimal.ZERO;
                if (total != 0L) {
                    pourcent = new BigDecimal(montant).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).abs().movePointRight(2).setScale(tableElementPourcent.getDecimalDigits(), RoundingMode.HALF_UP);
                }
                return pourcent;
            }
        });
        tableElementPourcent.addModificationListener(tableElementMontant);
        tableElementMontant.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal percent = row.getBigDecimal("POURCENT");
                long total = row.getForeign("ID_ECRITURE").getLong("DEBIT") - row.getForeign("ID_ECRITURE").getLong("CREDIT");
                BigDecimal montant = percent.movePointLeft(2).multiply(new BigDecimal(total)).setScale(0, RoundingMode.HALF_UP);
                return montant.longValue();
            }
        });
        tableElementMontant.setRenderer(this.deviseRenderer);
    }

    public RowValuesTableModel getModel() {
        return this.model;
    }
}

