/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class RapprochementBancaireSheetXML
extends AbstractListeSheetXml {
    private static final SQLTable tableEcriture = base.getTable("ECRITURE");
    private static final SQLTable tableMvt = base.getTable("MOUVEMENT");
    private static final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private static final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    private SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    private Date dateDu;
    private Date dateAu;
    private String compteDeb;
    private String numeroReleve;
    private final boolean detail;
    private final BigDecimal soldeDepart;
    public static String TEMPLATE_ID = "EtatRapprochement";
    public static String TEMPLATE_PROPERTY_NAME = "LocationEtatRapprochement";
    Date date;
    private String toDay = dateFormat.format(new Date());
    private int size;

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return "Rapprochement" + this.date.getTime();
    }

    @Override
    protected String getStoragePathP() {
        return "Rapprochement";
    }

    public RapprochementBancaireSheetXML(Date du, Date au, String compteDep, boolean detail, String numeroReleve, BigDecimal soldeDepart) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.printer = PrinterNXProps.getInstance().getStringProperty("GrandLivrePrinter");
        this.dateAu = au;
        this.dateDu = du;
        this.compteDeb = compteDep.trim();
        this.numeroReleve = numeroReleve;
        this.detail = detail;
        this.soldeDepart = soldeDepart;
    }

    @Override
    protected void createListeValues() {
        Date d = new Date();
        SQLRowValues vals = new SQLRowValues(tableEcriture);
        vals.put("ID_COMPTE_PCE", null);
        vals.put("COMPTE_NUMERO", null);
        vals.put("COMPTE_NOM", null);
        if (tableEcriture.contains("NOM_PIECE")) {
            vals.put("NOM_PIECE", null);
        }
        vals.put("ID_JOURNAL", null);
        vals.put("JOURNAL_CODE", null);
        vals.put("JOURNAL_NOM", null);
        vals.putRowValues("ID_MOUVEMENT").put("NUMERO", null).putRowValues("ID_PIECE").put("NOM", null);
        vals.put("CREDIT", null);
        vals.put("DEBIT", null);
        vals.put("DATE", null);
        vals.put("NOM", null);
        vals.put("NOM_PIECE", null);
        vals.put("POINTEE", null);
        vals.put("DATE_POINTEE", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                Where w = new Where((FieldRef)tableEcriture.getField("DATE"), RapprochementBancaireSheetXML.this.dateDu, (Object)RapprochementBancaireSheetXML.this.dateAu);
                if (RapprochementBancaireSheetXML.this.numeroReleve != null && RapprochementBancaireSheetXML.this.numeroReleve.trim().length() > 0) {
                    w = w.or(new Where((FieldRef)tableEcriture.getField("POINTEE"), "=", (Object)RapprochementBancaireSheetXML.this.numeroReleve));
                }
                w = w.and(new Where((FieldRef)tableEcriture.getField("COMPTE_NUMERO"), "=", (Object)RapprochementBancaireSheetXML.this.compteDeb));
                w = w.and(new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", tableMvt.getField("ID")));
                sel.setWhere(w);
                sel.addFieldOrder(tableEcriture.getField("COMPTE_NUMERO"));
                sel.addFieldOrder(tableEcriture.getField("DATE"));
                sel.addFieldOrder(tableMvt.getField("NUMERO"));
                System.err.println(sel.asString());
                return sel;
            }
        });
        List<SQLRowValues> list = fetcher.fetch();
        this.size = list.size();
        System.err.println("START CREATE Rapprochement, NB ecritures  " + this.size);
        ArrayList<Map<String, Object>> tableauVals = new ArrayList<Map<String, Object>>();
        this.listAllSheetValues.put(0, tableauVals);
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, style);
        Line lineSoldePointe = new Line("Solde point\u00e9 du compte " + this.compteDeb + " au " + dateFormatEcr.format(this.dateAu));
        Line lineSoldeAdjust = new Line("Solde r\u00e9ajust\u00e9 du compte " + this.compteDeb + " au " + dateFormatEcr.format(this.dateAu));
        Line lineSoldeNonPointe = new Line("Solde non point\u00e9 du compte " + this.compteDeb + " au " + dateFormatEcr.format(this.dateAu));
        Line lineSoldeAutrePointe = new Line("Solde point\u00e9 autre relev\u00e9 du compte " + this.compteDeb + " au " + dateFormatEcr.format(this.dateAu));
        if (this.soldeDepart != null) {
            Line lineSoldeDepart = new Line("Solde de d\u00e9part du compte " + this.compteDeb + " au " + dateFormatEcr.format(this.dateAu));
            SQLRowValues rowSoldeDepart = new SQLRowValues(tableEcriture);
            if (this.soldeDepart.signum() > 0) {
                rowSoldeDepart.put("DEBIT", this.soldeDepart.movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue());
                rowSoldeDepart.put("CREDIT", 0);
            } else {
                rowSoldeDepart.put("CREDIT", this.soldeDepart.movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue());
                rowSoldeDepart.put("DEBIT", 0);
            }
            lineSoldePointe.cumulRow(rowSoldeDepart);
            lineSoldeAdjust.cumulRow(rowSoldeDepart);
            lineSoldeDepart.cumulRow(rowSoldeDepart);
            tableauVals.add(lineSoldeDepart.getMapValues());
            style.put(tableauVals.size() - 1, "Titre 1");
        }
        ArrayList<Line> lineNonPointee = new ArrayList<Line>();
        ArrayList<Line> linePointee = new ArrayList<Line>();
        ArrayList<Line> linePointeeAutre = new ArrayList<Line>();
        for (SQLRowValues ecrVals : list) {
            String codeP = ecrVals.getString("POINTEE");
            if (codeP == null || codeP.trim().length() == 0) {
                lineNonPointee.add(new Line(ecrVals));
                lineSoldeNonPointe.cumulRow(ecrVals);
                lineSoldeAdjust.cumulRow(ecrVals);
                continue;
            }
            if (this.numeroReleve == null || this.numeroReleve.trim().length() == 0 || this.numeroReleve.trim().equals(codeP)) {
                linePointee.add(new Line(ecrVals));
                lineSoldePointe.cumulRow(ecrVals);
                lineSoldeAdjust.cumulRow(ecrVals);
                continue;
            }
            linePointeeAutre.add(new Line(ecrVals));
            lineSoldeAutrePointe.cumulRow(ecrVals);
        }
        Collections.sort(lineNonPointee, new Comparator<Line>(){

            @Override
            public int compare(Line o1, Line o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        if (this.detail) {
            for (Line line : linePointee) {
                tableauVals.add(line.getMapValues());
                style.put(tableauVals.size() - 1, "Normal");
            }
        }
        tableauVals.add(lineSoldePointe.getMapValues());
        style.put(tableauVals.size() - 1, "Titre 1");
        for (Line line : lineNonPointee) {
            tableauVals.add(line.getMapValues());
            style.put(tableauVals.size() - 1, "Normal");
        }
        if (linePointeeAutre.isEmpty()) {
            tableauVals.add(lineSoldeAdjust.getMapValues());
            style.put(tableauVals.size() - 1, "Titre 1");
        } else {
            tableauVals.add(lineSoldeNonPointe.getMapValues());
            style.put(tableauVals.size() - 1, "Titre 1");
            tableauVals.add(lineSoldeAdjust.getMapValues());
            style.put(tableauVals.size() - 1, "Titre 1");
            for (Line line : linePointeeAutre) {
                tableauVals.add(line.getMapValues());
                style.put(tableauVals.size() - 1, "Normal");
            }
            tableauVals.add(lineSoldeAutrePointe.getMapValues());
            style.put(tableauVals.size() - 1, "Titre 1");
        }
        HashMap<String, Object> sheetVals = new HashMap<String, Object>();
        this.mapAllSheetValues.put(0, sheetVals);
        sheetVals.put("SOCIETE", String.valueOf(this.rowSociete.getString("TYPE")) + " " + this.rowSociete.getString("NOM"));
        sheetVals.put("DATE_EDITION", new Date());
        sheetVals.put("TITRE", "Etat de rapprochement du " + dateFormatEcr.format(this.dateDu) + " au " + dateFormatEcr.format(this.dateAu) + " du compte " + this.compteDeb);
        Date end = new Date();
        System.err.println("///////// TAKE " + (end.getTime() - d.getTime()) + " millisecondes TO CREATE MAP");
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    public int getSize() {
        return this.size;
    }

    private class Line {
        private String journal;
        private String codeJournal;
        private String piece;
        private String nom;
        private Date date;
        private long debit;
        private long credit;

        public Line(SQLRowAccessor rowEcr) {
            this.journal = rowEcr.getString("JOURNAL_NOM");
            this.codeJournal = rowEcr.getString("JOURNAL_CODE");
            this.piece = rowEcr.getString("NOM_PIECE");
            this.date = rowEcr.getDate("DATE").getTime();
            this.debit = rowEcr.getLong("DEBIT");
            this.credit = rowEcr.getLong("CREDIT");
            this.nom = rowEcr.getString("NOM");
        }

        public Line(String nom) {
            this.nom = nom;
            this.debit = 0L;
            this.credit = 0L;
        }

        public Date getDate() {
            return this.date;
        }

        public void cumulRow(SQLRowAccessor rowEcr) {
            this.debit += rowEcr.getLong("DEBIT");
            this.credit += rowEcr.getLong("CREDIT");
        }

        public Map<String, Object> getMapValues() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("CODE_JOURNAL", this.codeJournal);
            map.put("NOM_JOURNAL", this.journal);
            map.put("PIECE", this.piece);
            map.put("DATE", this.date);
            map.put("NOM", this.nom);
            map.put("DEBIT", new BigDecimal(this.debit).movePointLeft(2));
            map.put("CREDIT", new BigDecimal(this.credit).movePointLeft(2));
            map.put("SOLDE", new BigDecimal(this.debit - this.credit).movePointLeft(2));
            return map;
        }
    }
}

