/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class BalanceSheet
extends SheetInterface {
    private static int debutFill;
    private static int endFill;
    private static final SQLTable tableEcriture;
    private static final SQLTable tableCompte;
    private boolean centralClient;
    private boolean centralFourn;
    private boolean centralFournImmo;
    private boolean hideCompteSolde;
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    public static String TEMPLATE_ID;
    public static String TEMPLATE_PROPERTY_NAME;
    private Date dateAu;
    private Date dateDu;
    private String compteDeb;
    private String compteEnd;
    private boolean viewMode = true;
    private long totalDebitBalance = 0L;
    private long totalCreditBalance = 0L;
    private List<Compte> vecteurCompte = new ArrayList<Compte>();

    static {
        tableEcriture = base.getTable("ECRITURE");
        tableCompte = base.getTable("COMPTE_PCE");
        TEMPLATE_ID = "Balance";
        TEMPLATE_PROPERTY_NAME = "LocationBalance";
        BalanceSheet.setSize(7, 58);
    }

    public static void setSize(int debut, int fin) {
        debutFill = debut;
        endFill = fin;
    }

    @Override
    protected String getYear() {
        return "";
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    public BalanceSheet(Date du, Date au, String compteDeb, String compteEnd, boolean centralClient, boolean centralFourn, boolean centralFournImmo, boolean displayAll, boolean hideCompteSolde) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.nbRowsPerPage = 61;
        this.printer = PrinterNXProps.getInstance().getStringProperty("BalancePrinter");
        this.modele = "Balance.ods";
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        this.dateAu = au;
        this.dateDu = du;
        this.viewMode = displayAll;
        this.compteDeb = compteDeb;
        this.compteEnd = compteEnd;
        this.centralClient = centralClient;
        this.centralFourn = centralFourn;
        this.centralFournImmo = centralFournImmo;
        this.hideCompteSolde = hideCompteSolde;
        this.createMap();
    }

    private void makeEntete(int rowDeb) {
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        this.mCell.put("A" + rowDeb, rowSociete.getObject("NOM"));
        this.mCell.put("E" + rowDeb, "Edition du " + this.dateFormat.format(new Date()));
        System.err.println("MAKE ENTETE");
    }

    private void makePiedPage(int row) {
        if (this.dateDu == null) {
            this.mCell.put("C" + row, "Balance au " + this.dateFormatEcr.format(this.dateAu));
        } else {
            this.mCell.put("C" + row, "Balance du " + this.dateFormatEcr.format(this.dateDu) + " au " + this.dateFormatEcr.format(this.dateAu));
        }
        this.mCell.put("B" + row, "Du compte " + this.compteDeb + " \u00e0 " + this.compteEnd);
    }

    private void makeSousTotalClasse(int row, long debit, long credit, String classe) {
        this.mCell.put("A" + row, "Total classe " + classe);
        this.mCell.put("B" + row, "");
        this.mCell.put("C" + row, new Double(GestionDevise.currencyToString(debit, false)));
        this.mCell.put("D" + row, new Double(GestionDevise.currencyToString(credit, false)));
        this.mCell.put("E" + row, new Double(GestionDevise.currencyToString(debit - credit, false)));
        this.mapStyleRow.put(new Integer(row), "Titre 1");
    }

    @Override
    protected void createMap() {
        int posLine = 1;
        int firstLine = 1;
        this.nbPage = 0;
        long totalDebit = 0L;
        long totalCredit = 0L;
        long sousTotalDebit = 0L;
        long sousTotalCredit = 0L;
        long totalDebitClient = 0L;
        long totalCreditClient = 0L;
        long totalDebitFourn = 0L;
        long totalCreditFourn = 0L;
        long totalDebitFournImmo = 0L;
        long totalCreditFournImmo = 0L;
        String numCptClient = "411";
        String nomCptClient = "Clients";
        String numCptFourn = "401";
        String nomCptFourn = "Fournisseurs";
        String numCptFournImmo = "404";
        String nomCptFournImmo = "Fournisseurs d'immobilisations";
        boolean addedLine = false;
        boolean addedLineImmo = false;
        boolean addedLineFourn = false;
        int j = 0;
        String classe = "";
        if (this.viewMode) {
            this.getBalance();
            int i = 0;
            while (i < this.vecteurCompte.size()) {
                System.err.println("START NEW PAGE; POS : " + posLine);
                this.makeEntete(posLine);
                posLine += debutFill - 1;
                j = 0;
                while (j < endFill - debutFill + 1 && i < this.vecteurCompte.size()) {
                    Compte compte = this.vecteurCompte.get(i);
                    String numeroCpt = compte.getNumero();
                    String nomCpt = compte.getNom();
                    long deb = compte.getTotalDebit();
                    long cred = compte.getTotalCredit();
                    totalCredit += cred;
                    sousTotalCredit += cred;
                    totalDebit += deb;
                    sousTotalDebit += deb;
                    this.mCell.put("A" + posLine, numeroCpt);
                    this.mCell.put("B" + posLine, nomCpt);
                    this.mCell.put("C" + posLine, new Double(GestionDevise.currencyToString(deb, false)));
                    this.mCell.put("D" + posLine, new Double(GestionDevise.currencyToString(cred, false)));
                    this.mCell.put("E" + posLine, new Double(GestionDevise.currencyToString(deb - cred, false)));
                    if (compte.getSousCompte().isEmpty()) {
                        this.mapStyleRow.put(new Integer(posLine), "Normal");
                    } else {
                        this.mapStyleRow.put(new Integer(posLine), "Titre 1");
                    }
                    ++i;
                    ++posLine;
                    ++j;
                }
                if (i >= this.vecteurCompte.size() && j < endFill - debutFill + 1) {
                    this.makeSousTotalClasse(posLine, sousTotalDebit, sousTotalCredit, classe);
                }
                posLine = firstLine + endFill;
                this.mCell.put("C" + posLine, totalDebit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit, false)));
                this.mCell.put("D" + posLine, totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalCredit, false)));
                this.mCell.put("E" + posLine, totalDebit - totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
                this.makePiedPage(posLine += 2);
                firstLine = ++posLine;
                ++this.nbPage;
            }
        } else {
            this.mapReplace = new HashMap();
            this.mCell = new HashMap();
            this.mapStyleRow = new HashMap();
            SQLSelect sel = new SQLSelect();
            sel.addSelect(tableCompte.getField("ID"));
            sel.addSelect(tableEcriture.getField("DEBIT"), "SUM");
            sel.addSelect(tableEcriture.getField("CREDIT"), "SUM");
            Where w = new Where((FieldRef)tableEcriture.getField("DATE"), this.dateDu, (Object)this.dateAu);
            if (this.dateDu == null) {
                w = new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)this.dateAu);
            }
            w = this.compteDeb.equals(this.compteEnd) ? w.and(new Where((FieldRef)tableCompte.getField("NUMERO"), "=", (Object)this.compteDeb)) : w.and(new Where((FieldRef)tableCompte.getField("NUMERO"), (Object)this.compteDeb, (Object)this.compteEnd));
            Where wCloture = new Where((FieldRef)tableEcriture.getField("NOM"), "NOT LIKE", (Object)"Fermeture du compte%");
            wCloture = wCloture.and(new Where((FieldRef)tableEcriture.getField("DATE"), "=", (Object)this.dateAu));
            wCloture = wCloture.or(new Where((FieldRef)tableEcriture.getField("DATE"), "<", (Object)this.dateAu));
            w = w.and(wCloture);
            sel.setWhere(w);
            String req = String.valueOf(sel.asString()) + " AND \"ECRITURE\".\"ID_COMPTE_PCE\" = \"COMPTE_PCE\".\"ID\" GROUP BY  \"COMPTE_PCE\".\"NUMERO\", \"COMPTE_PCE\".\"ID\" ";
            if (this.hideCompteSolde) {
                req = String.valueOf(req) + " HAVING SUM(\"ECRITURE\".\"DEBIT\")-SUM(\"ECRITURE\".\"CREDIT\")!=0";
            }
            req = String.valueOf(req) + " ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
            System.err.println(req);
            List l = (List)base.getDataSource().execute(req, new ArrayListHandler());
            SQLSelect selCompte = new SQLSelect();
            selCompte.addSelectStar(tableCompte);
            List<SQLRow> compteRows = SQLRowListRSH.execute(selCompte);
            HashMap<Integer, SQLRow> mapCompte = new HashMap<Integer, SQLRow>();
            for (SQLRow sqlRow : compteRows) {
                mapCompte.put(sqlRow.getID(), sqlRow);
            }
            int i = 0;
            while (i < l.size()) {
                System.err.println("START NEW PAGE; POS : " + posLine);
                this.makeEntete(posLine);
                posLine += debutFill - 1;
                j = 0;
                while (j < endFill - debutFill + 1 && i < l.size()) {
                    Object[] o = (Object[])l.get(i);
                    int idCpt = Integer.parseInt(o[0].toString());
                    SQLRow rowCpt = (SQLRow)mapCompte.get(idCpt);
                    String numeroCpt = rowCpt.getString("NUMERO").trim();
                    String nomCpt = rowCpt.getString("NOM");
                    if (classe.trim().length() != 0 && numeroCpt.length() > 0 && !classe.trim().equalsIgnoreCase(numeroCpt.substring(0, 1))) {
                        this.makeSousTotalClasse(posLine, sousTotalDebit, sousTotalCredit, classe);
                        sousTotalCredit = 0L;
                        sousTotalDebit = 0L;
                        classe = numeroCpt.substring(0, 1);
                    } else {
                        if (classe.trim().length() == 0 && numeroCpt.trim().length() > 0) {
                            classe = numeroCpt.substring(0, 1);
                        }
                        long deb = new Double(o[1].toString()).longValue();
                        long cred = new Double(o[2].toString()).longValue();
                        totalCredit += cred;
                        sousTotalCredit += cred;
                        totalDebit += deb;
                        sousTotalDebit += deb;
                        if (this.centralClient && (numeroCpt.equalsIgnoreCase("411") || numeroCpt.startsWith("411"))) {
                            totalDebitClient += deb;
                            totalCreditClient += cred;
                            deb = totalDebitClient;
                            cred = totalCreditClient;
                        } else if (this.centralFournImmo && (numeroCpt.equalsIgnoreCase("404") || numeroCpt.startsWith("404"))) {
                            totalDebitFournImmo += deb;
                            totalCreditFournImmo += cred;
                            deb = totalDebitFournImmo;
                            cred = totalCreditFournImmo;
                        } else if (this.centralFourn && (numeroCpt.equalsIgnoreCase("401") || numeroCpt.startsWith("401"))) {
                            totalDebitFourn += deb;
                            totalCreditFourn += cred;
                            deb = totalDebitFourn;
                            cred = totalCreditFourn;
                        }
                        if (this.centralClient && !numeroCpt.equalsIgnoreCase("411") && numeroCpt.startsWith("411")) {
                            if (addedLine) {
                                --posLine;
                                --j;
                            } else {
                                addedLine = true;
                            }
                            this.mCell.put("A" + posLine, numCptClient);
                            this.mCell.put("B" + posLine, nomCptClient);
                        } else if (this.centralFourn && !numeroCpt.equalsIgnoreCase("401") && numeroCpt.startsWith("401")) {
                            if (addedLineFourn) {
                                --posLine;
                                --j;
                            } else {
                                addedLineFourn = true;
                            }
                            this.mCell.put("A" + posLine, numCptFourn);
                            this.mCell.put("B" + posLine, nomCptFourn);
                        } else if (this.centralFournImmo && !numeroCpt.equalsIgnoreCase("404") && numeroCpt.startsWith("404")) {
                            if (addedLineImmo) {
                                --posLine;
                                --j;
                            } else {
                                addedLineImmo = true;
                            }
                            this.mCell.put("A" + posLine, numCptFournImmo);
                            this.mCell.put("B" + posLine, nomCptFournImmo);
                        } else {
                            this.mCell.put("A" + posLine, numeroCpt);
                            this.mCell.put("B" + posLine, nomCpt);
                        }
                        this.mCell.put("C" + posLine, new Double(GestionDevise.currencyToString(deb, false)));
                        this.mCell.put("D" + posLine, new Double(GestionDevise.currencyToString(cred, false)));
                        this.mCell.put("E" + posLine, new Double(GestionDevise.currencyToString(deb - cred, false)));
                        this.mapStyleRow.put(new Integer(posLine), "Normal");
                        ++i;
                    }
                    ++posLine;
                    ++j;
                }
                if (i >= l.size() && j < endFill - debutFill + 1) {
                    this.makeSousTotalClasse(posLine, sousTotalDebit, sousTotalCredit, classe);
                }
                posLine = firstLine + endFill;
                this.mCell.put("C" + posLine, totalDebit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit, false)));
                this.mCell.put("D" + posLine, totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalCredit, false)));
                this.mCell.put("E" + posLine, totalDebit - totalCredit == 0L ? new Double(0.0) : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
                this.makePiedPage(posLine += 2);
                firstLine = ++posLine;
                ++this.nbPage;
                if (i < l.size() || j < endFill - debutFill + 1) continue;
                this.makeEntete(posLine);
                this.makeSousTotalClasse(posLine += debutFill - 1, sousTotalDebit, sousTotalCredit, classe);
                ++this.nbPage;
            }
        }
        if (this.nbPage < 1) {
            this.nbPage = 1;
        }
    }

    public void getBalance() {
        HashMap<Number, Long> mapCompteDebit = new HashMap<Number, Long>();
        HashMap<Number, Long> mapCompteCredit = new HashMap<Number, Long>();
        ArrayList<Compte> comptes = new ArrayList<Compte>();
        this.totalDebitBalance = 0L;
        this.totalCreditBalance = 0L;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(compteTable.getField("ID"));
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        sel.addSelect(compteTable.getField("NUMERO"));
        sel.setDistinct(true);
        Where w = new Where((FieldRef)tableEcriture.getField("DATE"), this.dateDu, (Object)this.dateAu);
        if (this.dateDu == null) {
            w = new Where((FieldRef)tableEcriture.getField("DATE"), "<=", (Object)this.dateAu);
        }
        sel.setWhere(w.and(new Where((FieldRef)compteTable.getField("ID"), "=", ecritureTable.getField("ID_COMPTE_PCE"))));
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\",\"COMPTE_PCE\".\"NUMERO\"  ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        System.out.println(req);
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        if (myList.size() != 0) {
            int i = 0;
            while (i < myList.size()) {
                long credit;
                Object[] tmp = (Object[])myList.get(i);
                long debit = Long.parseLong(tmp[1].toString());
                if (debit - (credit = Long.parseLong(tmp[2].toString())) != 0L || !this.hideCompteSolde) {
                    mapCompteDebit.put((Number)tmp[0], debit);
                    mapCompteCredit.put((Number)tmp[0], credit);
                }
                ++i;
            }
        }
        sel = new SQLSelect();
        sel.addSelect(compteTable.getKey());
        sel.addSelect(compteTable.getField("NUMERO"));
        sel.addSelect(compteTable.getField("NOM"));
        sel.addRawOrder("\"COMPTE_PCE\".\"NUMERO\"");
        String reqCompte = sel.asString();
        System.out.println(req);
        Object obCompte = base.getDataSource().execute(reqCompte, new ArrayListHandler());
        List myListCompte = (List)obCompte;
        if (myListCompte.size() != 0) {
            int i = 0;
            while (i < myListCompte.size()) {
                Object[] tmp = (Object[])myListCompte.get(i);
                System.err.println("Compte " + tmp[1].toString().trim());
                long totalDebit = 0L;
                long totalCredit = 0L;
                if (mapCompteDebit.get(tmp[0]) != null) {
                    totalDebit = Long.parseLong(((Long)mapCompteDebit.get(tmp[0])).toString());
                }
                if (mapCompteCredit.get(tmp[0]) != null) {
                    totalCredit = Long.parseLong(((Long)mapCompteCredit.get(tmp[0])).toString());
                }
                this.totalDebitBalance += totalDebit;
                this.totalCreditBalance += totalCredit;
                ArrayList<String> sousCompte = new ArrayList<String>();
                int j = i + 1;
                while (j < myListCompte.size() - 1) {
                    Object[] tmpNext = (Object[])myListCompte.get(j);
                    if (!tmpNext[1].toString().trim().startsWith(tmp[1].toString().trim())) break;
                    System.err.println("Sous Compte " + tmpNext[1].toString().trim());
                    sousCompte.add(tmpNext[1].toString().trim());
                    if (mapCompteDebit.get(tmpNext[0]) != null) {
                        totalDebit += Long.parseLong(((Long)mapCompteDebit.get(tmpNext[0])).toString());
                    }
                    if (mapCompteCredit.get(tmpNext[0]) != null) {
                        totalCredit += Long.parseLong(((Long)mapCompteCredit.get(tmpNext[0])).toString());
                    }
                    ++j;
                }
                if ((double)totalDebit != 0.0 || (double)totalCredit != 0.0) {
                    Compte cpt = new Compte(((Number)tmp[0]).intValue(), tmp[1].toString(), tmp[2].toString(), "", totalDebit, totalCredit);
                    cpt.addSousCompte(sousCompte);
                    comptes.add(cpt);
                }
                ++i;
            }
        }
        this.vecteurCompte = comptes;
    }
}

