/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.Date;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.ui.PointagePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;

public class PointageModel
extends AbstractTableModel {
    private String[] titresCol;
    private String[] titresRow;
    private PointagePanel panel;
    private long debitListe;
    private long creditListe;
    private long debitTotal;
    private long creditTotal = 0L;
    private long debitPointe;
    private long creditPointe = 0L;
    private long debitNonPointe;
    private long creditNonPointe = 0L;
    private long creditSelection = 0L;
    private long debitSelection;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tableEcr = base.getTable("ECRITURE");
    int idCpt;
    private SwingWorker<String, Object> workerUpdater;

    public PointageModel(int idCpt, PointagePanel panel) {
        this.panel = panel;
        this.debitNonPointe = 0L;
        this.debitPointe = 0L;
        this.debitTotal = 0L;
        this.debitSelection = 0L;
        this.idCpt = idCpt;
        this.titresCol = new String[6];
        this.titresCol[0] = "Totaux p\u00e9riode";
        this.titresCol[1] = "Point\u00e9";
        this.titresCol[2] = "Relev\u00e9 courant";
        this.titresCol[3] = "Total";
        this.titresCol[4] = "S\u00e9lection";
        this.titresCol[5] = "Liste";
        this.titresRow = new String[3];
        this.titresRow[0] = "D\u00e9bit";
        this.titresRow[1] = "Cr\u00e9dit";
        this.titresRow[2] = "Solde";
        this.updateTotauxCompte();
    }

    public void setIdCompte(int id) {
        this.idCpt = id;
        this.updateTotauxCompte();
        this.updateSelection(null);
    }

    public void updateSelection(int[] rowIndex) {
        this.creditSelection = 0L;
        this.debitSelection = 0L;
        if (rowIndex != null) {
            int i = 0;
            while (i < rowIndex.length) {
                SQLRow row = tableEcr.getRow(rowIndex[i]);
                if (row != null) {
                    this.debitSelection += ((Long)row.getObject("DEBIT")).longValue();
                    this.creditSelection += ((Long)row.getObject("CREDIT")).longValue();
                }
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public void updateTotauxCompte() {
        this.updateTotauxCompte(null, null, null);
    }

    public void updateTotauxCompte(final DeviseField depart, final DeviseField arrive, final DeviseField ecart) {
        final Date deb = this.panel.getDateDeb();
        final Date fin = this.panel.getDateFin();
        if (this.workerUpdater != null) {
            this.workerUpdater.cancel(true);
        }
        this.workerUpdater = new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                SQLSelect sel = new SQLSelect();
                sel.addSelect(tableEcr.getField("CREDIT"), "SUM");
                sel.addSelect(tableEcr.getField("DEBIT"), "SUM");
                Where w = new Where((FieldRef)tableEcr.getField("ID_COMPTE_PCE"), "=", PointageModel.this.idCpt);
                if (deb != null && fin != null) {
                    w = w.and(new Where((FieldRef)tableEcr.getField("DATE"), deb, (Object)fin));
                } else if (deb != null) {
                    w = w.and(new Where((FieldRef)tableEcr.getField("DATE"), ">=", (Object)deb));
                } else if (fin != null) {
                    w = w.and(new Where((FieldRef)tableEcr.getField("DATE"), "<=", (Object)fin));
                }
                sel.setWhere(w.and(new Where((FieldRef)tableEcr.getField("POINTEE"), "!=", (Object)"")));
                String reqPointee = sel.toString();
                Object obPointee = base.getDataSource().execute(reqPointee, new ArrayListHandler());
                List myListPointee = (List)obPointee;
                PointageModel.this.creditPointe = 0L;
                PointageModel.this.debitPointe = 0L;
                if (!myListPointee.isEmpty()) {
                    int i = 0;
                    while (i < myListPointee.size()) {
                        Object[] objTmp = (Object[])myListPointee.get(i);
                        if (objTmp[0] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.creditPointe = pointageModel.creditPointe + ((Number)objTmp[0]).longValue();
                        }
                        if (objTmp[1] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.debitPointe = pointageModel.debitPointe + ((Number)objTmp[1]).longValue();
                        }
                        ++i;
                    }
                }
                sel.setWhere(w.and(new Where((FieldRef)tableEcr.getField("POINTEE"), "=", (Object)PointageModel.this.panel.getCodePointage())));
                String reqReleveCourant = sel.toString();
                Object obReleveCourant = base.getDataSource().execute(reqReleveCourant, new ArrayListHandler());
                List myListReleveCourant = (List)obReleveCourant;
                PointageModel.this.creditNonPointe = 0L;
                PointageModel.this.debitNonPointe = 0L;
                if (!myListReleveCourant.isEmpty()) {
                    int i = 0;
                    while (i < myListReleveCourant.size()) {
                        Object[] objTmp = (Object[])myListReleveCourant.get(i);
                        if (objTmp[0] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.creditNonPointe = pointageModel.creditNonPointe + ((Number)objTmp[0]).longValue();
                        }
                        if (objTmp[1] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.debitNonPointe = pointageModel.debitNonPointe + ((Number)objTmp[1]).longValue();
                        }
                        ++i;
                    }
                }
                sel.setWhere(w);
                String reqReleveTotal = sel.toString();
                Object obReleveTotal = base.getDataSource().execute(reqReleveTotal, new ArrayListHandler());
                List myListReleveTotal = (List)obReleveTotal;
                PointageModel.this.creditTotal = 0L;
                PointageModel.this.debitTotal = 0L;
                if (!myListReleveTotal.isEmpty()) {
                    int i = 0;
                    while (i < myListReleveTotal.size()) {
                        Object[] objTmp = (Object[])myListReleveTotal.get(i);
                        if (objTmp[0] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.creditTotal = pointageModel.creditTotal + ((Number)objTmp[0]).longValue();
                        }
                        if (objTmp[1] != null) {
                            PointageModel pointageModel = PointageModel.this;
                            pointageModel.debitTotal = pointageModel.debitTotal + ((Number)objTmp[1]).longValue();
                        }
                        ++i;
                    }
                }
                PointageModel.this.creditListe = 0L;
                PointageModel.this.debitListe = 0L;
                IListe listeEcr = PointageModel.this.panel.getEcriturePanel().getListe();
                int i = 0;
                while (i < listeEcr.getRowCount()) {
                    SQLRowValues rowAt = ITableModel.getLine(listeEcr.getModel(), i).getRow();
                    if (rowAt.getObject("CREDIT") != null) {
                        PointageModel pointageModel = PointageModel.this;
                        pointageModel.creditListe = pointageModel.creditListe + rowAt.getLong("CREDIT");
                    }
                    if (rowAt.getObject("DEBIT") != null) {
                        PointageModel pointageModel = PointageModel.this;
                        pointageModel.debitListe = pointageModel.debitListe + rowAt.getLong("DEBIT");
                    }
                    ++i;
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                if (arrive != null && depart != null && ecart != null) {
                    Long valueArrive = arrive.getValue();
                    Long valueDepart = depart.getValue();
                    if (valueArrive != null && valueDepart != null) {
                        ecart.setValue(valueArrive - valueDepart - PointageModel.this.debitNonPointe + PointageModel.this.creditNonPointe);
                    } else {
                        ecart.setValue((Long)null);
                    }
                }
                PointageModel.this.fireTableDataChanged();
            }
        };
        this.workerUpdater.execute();
    }

    @Override
    public String getColumnName(int column) {
        return this.titresCol[column];
    }

    @Override
    public int getColumnCount() {
        return this.titresCol.length;
    }

    @Override
    public int getRowCount() {
        return this.titresRow.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Long.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.titresRow[rowIndex];
        }
        if (columnIndex == 1) {
            if (rowIndex == 0) {
                return this.debitPointe;
            }
            if (rowIndex == 1) {
                return this.creditPointe;
            }
            if (rowIndex == 2) {
                return this.debitPointe - this.creditPointe;
            }
        }
        if (columnIndex == 2) {
            if (rowIndex == 0) {
                return this.debitNonPointe;
            }
            if (rowIndex == 1) {
                return this.creditNonPointe;
            }
            if (rowIndex == 2) {
                return this.debitNonPointe - this.creditNonPointe;
            }
        }
        if (columnIndex == 3) {
            if (rowIndex == 0) {
                return this.debitTotal;
            }
            if (rowIndex == 1) {
                return this.creditTotal;
            }
            if (rowIndex == 2) {
                return this.debitTotal - this.creditTotal;
            }
        }
        if (columnIndex == 4) {
            if (rowIndex == 0) {
                return this.debitSelection;
            }
            if (rowIndex == 1) {
                return this.creditSelection;
            }
            if (rowIndex == 2) {
                return this.debitSelection - this.creditSelection;
            }
        }
        if (columnIndex == 5) {
            if (rowIndex == 0) {
                return this.debitListe;
            }
            if (rowIndex == 1) {
                return this.creditListe;
            }
            if (rowIndex == 2) {
                return this.debitListe - this.creditListe;
            }
        }
        return null;
    }
}

