/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.importer;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import org.openconcerto.utils.Base64;

public class Transaction {
    public static final String TYPE_PRELEVEMENT = "directdebit";
    public static final String TYPE_AUTRE = "other";
    public static final String TYPE_VIREMENT = "transfer";
    public static final String TYPE_CARTE = "card";
    public static final String TYPE_CHEQUE = "check";
    public static final String TYPE_ESPECES = "cash";
    private String uuid;
    private BigDecimal amount;
    private String name;
    private String memo = "";
    private LocalDate date;
    private LocalDate dateValue;
    private String comment;
    private String type;
    private String hash;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        return this.uuid.equals(((Transaction)o).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(LocalDate date) {
        this.dateValue = date;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String toString() {
        return this.date + " amount:" + this.amount + " | " + this.name + "|" + this.memo + "[" + this.uuid + "]";
    }

    public String getType() {
        if (this.type == null) {
            String n = this.getName();
            if (n == null) {
                return TYPE_AUTRE;
            }
            String rawname = n.toUpperCase();
            this.type = TYPE_AUTRE;
            if (this.getAmount().compareTo(BigDecimal.ZERO) < 0) {
                if (rawname.contains("PRLV") || rawname.contains("PRELEV")) {
                    this.type = TYPE_PRELEVEMENT;
                } else if (rawname.contains("VIREMENT") || rawname.contains("VIR CPTE")) {
                    this.type = TYPE_VIREMENT;
                } else if (rawname.contains("CARTE")) {
                    this.type = TYPE_CARTE;
                } else if (rawname.contains("CHEQUE")) {
                    this.type = TYPE_CHEQUE;
                } else if (rawname.contains("ESPECES")) {
                    this.type = TYPE_ESPECES;
                }
            } else if (rawname.contains("VIR")) {
                this.type = TYPE_VIREMENT;
            } else if (rawname.contains("REM") && rawname.contains("CARTE")) {
                this.type = TYPE_CARTE;
            } else if (rawname.contains("REM") && rawname.contains("CHEQUE")) {
                this.type = TYPE_CHEQUE;
            } else if (rawname.contains("ESPECES")) {
                this.type = TYPE_ESPECES;
            }
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static void computeHashes(List<Transaction> transactions) {
        HashSet<String> hashes = new HashSet<String>();
        for (Transaction t : transactions) {
            LocalDate date2;
            StringBuilder b = new StringBuilder();
            LocalDate date = t.getDate();
            if (date != null) {
                b.append(date.getYear());
                b.append("_");
                b.append(date.getMonthValue());
                b.append("_");
                b.append(date.getDayOfMonth());
                b.append("_");
            }
            if ((date2 = t.getDateValue()) != null) {
                b.append(date2.getYear());
                b.append("_");
                b.append(date2.getMonthValue());
                b.append("_");
                b.append(date2.getDayOfMonth());
                b.append("_");
            }
            StringBuilder b2 = new StringBuilder();
            if (t.getAmount() != null) {
                b2.append(t.getAmount());
            }
            if (t.getType() != null) {
                b2.append(t.getType());
            }
            if (t.getMemo() != null) {
                b2.append(t.getMemo());
            }
            if (t.getName() != null) {
                b2.append(t.getName());
            }
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hash = digest.digest(b2.toString().getBytes(StandardCharsets.UTF_8));
                b.append(Base64.encodeBytes(hash));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
            String h = b.toString();
            if (hashes.contains(h)) {
                int i = 0;
                while (i < 1000) {
                    String newHash = String.valueOf(h) + "_" + i;
                    if (!hashes.contains(newHash)) {
                        h = newHash;
                        break;
                    }
                    ++i;
                }
            }
            t.setHash(h);
            hashes.add(h);
        }
    }
}

