/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ReleveBancaireElementSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ReleveBancaireSQLElement;
import org.openconcerto.erp.core.finance.accounting.importer.OFXParser;
import org.openconcerto.erp.core.finance.accounting.importer.Transaction;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.ui.WrapLayout;

public class ReleveBancaireFrame
extends JFrame {
    public ReleveBancaireFrame(final SQLElementDirectory dir) {
        final SQLRequestComboBox banqueSelect = new SQLRequestComboBox();
        banqueSelect.uiInit(dir.getElement(BanqueSQLElement.class).getComboRequest());
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        JSpinner spinnerYear = new JSpinner(new SpinnerNumberModel(year, year - 20, year + 10, 1));
        String[] months = new String[]{"Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre"};
        JComboBox<String> comboMontsh = new JComboBox<String>(months);
        JPanel tools = new JPanel();
        tools.setLayout(new WrapLayout());
        tools.add(banqueSelect);
        tools.add(comboMontsh);
        tools.add(spinnerYear);
        JButton importer = new JButton("Import OFX");
        tools.add(importer);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)tools, "North");
        ReleveBancaireElementSQLElement element = dir.getElement(ReleveBancaireElementSQLElement.class);
        ListeAddPanel add = new ListeAddPanel(element);
        add.setAddVisible(false);
        add.setModifyVisible(false);
        add.setDeleteVisible(false);
        p.add((Component)add, "Center");
        this.setContentPane(p);
        importer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OFXParser p = new OFXParser();
                    p.parse(new FileInputStream(new File("jan-aout2021.ofx")));
                    System.out.println("OFXTest.main() " + p.getStartDate() + " => " + p.getEndDate() + " : " + p.getCompleteMonth() + " : " + p.getBasicBankAccountNumber());
                    List<Transaction> transactions1 = p.getTransactions();
                    Collections.sort(transactions1, new Comparator<Transaction>(){

                        @Override
                        public int compare(Transaction o1, Transaction o2) {
                            return o1.getDateValue().compareTo(o2.getDateValue());
                        }
                    });
                    LocalDate min = transactions1.get(0).getDateValue();
                    LocalDate max = transactions1.get(transactions1.size() - 1).getDateValue();
                    p.parse(new FileInputStream(new File("avril-decembre-2021.ofx")));
                    System.out.println("OFXTest.main() " + p.getStartDate() + " => " + p.getEndDate() + " : " + p.getCompleteMonth() + " : " + p.getBasicBankAccountNumber());
                    List<Transaction> transactions2 = p.getTransactions();
                    for (Transaction t : transactions2) {
                        boolean alreadIn;
                        boolean bl = alreadIn = !t.getDateValue().isBefore(min) && !t.getDateValue().isAfter(max);
                        if (alreadIn) {
                            System.out.println("alreadIn : " + t);
                            continue;
                        }
                        transactions1.add(t);
                    }
                    System.out.println("OFXTest.main() " + transactions1.size());
                    System.out.println("OFXTest.main()" + transactions1.get(0).getDate() + " : " + transactions1.get(0).getDateValue());
                    System.out.println("OFXTest.main()" + transactions1.get(transactions1.size() - 1).getDate() + " : " + transactions1.get(transactions1.size() - 1).getDateValue());
                    for (Transaction t : transactions1) {
                        System.out.println(t);
                    }
                    int year = 2021;
                    ReleveBancaireSQLElement eReleve = dir.getElement(ReleveBancaireSQLElement.class);
                    int i = 0;
                    while (i < 12) {
                        ArrayList<Transaction> trs = new ArrayList<Transaction>();
                        BigDecimal total = BigDecimal.ZERO;
                        for (Transaction t : transactions1) {
                            if (t.getDateValue().getMonth().getValue() != i + 1 || t.getDateValue().getYear() != year) continue;
                            trs.add(t);
                            total = total.add(t.getAmount());
                        }
                        System.out.println(total);
                        Collections.sort(trs, new Comparator<Transaction>(){

                            @Override
                            public int compare(Transaction o1, Transaction o2) {
                                return o1.getDate().compareTo(o2.getDate());
                            }
                        });
                        int idBanque = banqueSelect.getSelectedId();
                        eReleve.importReleve(idBanque, i + 1, year, trs);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

