/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.component;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class DeviseHistoriqueSQLComponent
extends GroupSQLComponent {
    public static final String ID = "accounting.currencyrate.history";

    public DeviseHistoriqueSQLComponent(SQLElement element) {
        super(element);
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        SQLRow row = this.getTable().getRow(id);
        this.updateProduct(row);
        return id;
    }

    @Override
    public void update() {
        super.update();
        SQLRow row = this.getTable().getRow(this.getSelectedID());
        this.updateProduct(row);
    }

    @Override
    protected SQLRowValues createDefaults() {
        CurrencyConverter c = new CurrencyConverter();
        String companyCode = c.getCompanyCurrencyCode();
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("SRC", companyCode);
        return rowVals;
    }

    private void updateProduct(final SQLRow rowDeviseH) {
        int ans;
        final CurrencyConverter c = new CurrencyConverter();
        final String companyCode = c.getCompanyCurrencyCode();
        String srcCode = rowDeviseH.getString("SRC");
        if (srcCode.equalsIgnoreCase(companyCode) && (ans = JOptionPane.showConfirmDialog(null, "Voulez vous actualiser les prix d'achats?", "Actualisation tarif", 0)) == 0) {
            SwingWorker<Object, Object> w = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    final String codeDevise = rowDeviseH.getString("DST");
                    SQLRowValues rowValsARt = new SQLRowValues(DeviseHistoriqueSQLComponent.this.getTable().getTable("ARTICLE"));
                    rowValsARt.putNulls("PA_HT", "PA_DEVISE");
                    rowValsARt.putRowValues("ID_DEVISE_HA").putNulls("CODE");
                    SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsARt);
                    fetcher.addSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                        @Override
                        public SQLSelect transformChecked(SQLSelect input) {
                            SQLSelectJoin join = input.getJoin(DeviseHistoriqueSQLComponent.this.getTable().getTable("ARTICLE").getField("ID_DEVISE_HA"));
                            input.setWhere(new Where(join.getJoinedTable().getField("CODE"), "=", (Object)codeDevise));
                            return input;
                        }
                    }, 0);
                    List<SQLRowValues> result = fetcher.fetch();
                    Date date = new Date();
                    for (SQLRowValues sqRowValues : result) {
                        BigDecimal haDevise = sqRowValues.getBigDecimal("PA_DEVISE");
                        if (haDevise == null) {
                            haDevise = BigDecimal.ZERO;
                        }
                        BigDecimal convert = c.convert(haDevise, codeDevise, companyCode, date, true).setScale((int)sqRowValues.getTable().getField("PA_DEVISE").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                        try {
                            sqRowValues.createEmptyUpdateRow().put("PA_HT", convert).put("PRIX_METRIQUE_HA_1", convert).commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    SQLRowValues rowValsARtFour = new SQLRowValues(DeviseHistoriqueSQLComponent.this.getTable().getTable("ARTICLE_FOURNISSEUR"));
                    rowValsARtFour.putNulls("PA_HT", "PA_DEVISE");
                    rowValsARtFour.putRowValues("ID_DEVISE_HA").putNulls("CODE");
                    SQLRowValuesListFetcher fetcherFourni = SQLRowValuesListFetcher.create(rowValsARtFour);
                    fetcherFourni.addSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                        @Override
                        public SQLSelect transformChecked(SQLSelect input) {
                            SQLSelectJoin join = input.getJoin(DeviseHistoriqueSQLComponent.this.getTable().getTable("ARTICLE_FOURNISSEUR").getField("ID_DEVISE_HA"));
                            input.setWhere(new Where(join.getJoinedTable().getField("CODE"), "=", (Object)codeDevise));
                            return input;
                        }
                    }, 0);
                    List<SQLRowValues> resultFournisseur = fetcherFourni.fetch();
                    for (SQLRowValues sqRowValues : resultFournisseur) {
                        BigDecimal haDevise = sqRowValues.getBigDecimal("PA_DEVISE");
                        if (haDevise == null) {
                            haDevise = BigDecimal.ZERO;
                        }
                        BigDecimal convert = c.convert(haDevise, codeDevise, companyCode, date, true).setScale((int)sqRowValues.getTable().getField("PA_DEVISE").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                        try {
                            sqRowValues.createEmptyUpdateRow().put("PA_HT", convert).put("PRIX_METRIQUE_HA_1", convert).commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        JOptionPane.showMessageDialog(null, "Mise \u00e0 jour des tarifs termin\u00e9es", "Mise \u00e0 jour tarifs", 1);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour des tarifs!", e);
                    }
                }
            };
            w.run();
        }
    }
}

