/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.Tuple2;

public class ListeDesEcrituresAction
extends CreateFrameAbstractAction {
    public ListeDesEcrituresAction() {
        this.putValue("Name", "Liste des \u00e9critures");
    }

    public JFrame createFrame() {
        SQLTableModelSourceOnline src;
        final long time = Calendar.getInstance().getTimeInMillis();
        SQLElement element = Configuration.getInstance().getDirectory().getElement("ECRITURE");
        if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            src = element.getTableSource(true);
            src.getReq().setWhere(new Where((FieldRef)element.getTable().getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        } else {
            src = element.getTableSource(true);
        }
        final IListFrame frame = new IListFrame(new ListeAddPanel(element, new IListe(src)){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints res = super.createConstraints();
                res.gridwidth = 0;
                res.gridy = 1;
                return res;
            }

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonEffacer && this.getListe().fetchSelectedRow() != null) {
                    System.err.println("Archivage des \u00e9critures");
                    PanelFrame frame = new PanelFrame(new SuppressionEcrituresPanel(this.getListe().fetchSelectedRow().getInt("ID_MOUVEMENT")), "Suppression d'ecritures");
                    frame.pack();
                    frame.setResizable(false);
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }
        });
        frame.setDefaultCloseOperation(2);
        frame.getPanel().setSearchFullMode(true);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 4;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getInt("ID_EXERCICE_COMMON"));
        IListFilterDatePanel comp = new IListFilterDatePanel(frame.getPanel().getListe(), element.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        if (comp.getFromValue() == null) {
            comp.setDateDu((Date)rowExercice.getObject("DATE_DEB"));
        }
        c.weightx = 1.0;
        c.gridwidth = 0;
        frame.getPanel().add((Component)comp, c);
        ArrayList<SQLField> l = new ArrayList<SQLField>();
        l.add(element.getTable().getField("DEBIT"));
        l.add(element.getTable().getField("CREDIT"));
        List<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> initListe = IListTotalPanel.initListe(frame.getPanel().getListe(), Arrays.asList(element.getTable().getField("DEBIT"), element.getTable().getField("CREDIT")));
        IListTotalPanel compSel = new IListTotalPanel(frame.getPanel().getListe(), initListe, null, null, "S\u00e9lection", true);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        frame.getPanel().add((Component)new JLabel(), c);
        c.weightx = 0.0;
        ++c.gridx;
        compSel.addSubtract(initListe.get(0).get0(), initListe.get(1).get0());
        frame.getPanel().add((Component)compSel, c);
        IListTotalPanel comp2 = new IListTotalPanel(frame.getPanel().getListe(), l, "Total");
        ++c.gridx;
        c.weightx = 0.0;
        frame.getPanel().add((Component)comp2, c);
        JTable table = frame.getPanel().getListe().getJTable();
        frame.getPanel().setCloneVisible(false);
        frame.getPanel().setAddVisible(false);
        frame.getPanel().setModifyVisible(false);
        frame.getPanel().setReloadVisible(true);
        frame.getPanel().getListe().setModificationAllowed(false);
        frame.getPanel().getListe().getModel().invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = frame.getPanel().getListe().getModel().getRowCount() - 1;
                if (rowCount > 0) {
                    frame.getPanel().getListe().getJTable().setRowSelectionInterval(rowCount, rowCount);
                }
                System.err.println("Load ecritures : " + (Calendar.getInstance().getTimeInMillis() - time) + " ms");
            }
        });
        return frame;
    }

    public void correctNomPiece() {
        SQLTable tableMvt = Configuration.getInstance().getRoot().findTable("MOUVEMENT");
        SQLTable tablePiece = Configuration.getInstance().getRoot().findTable("PIECE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(tableMvt.getKey());
        sel.addSelect(tableMvt.getField("SOURCE"));
        sel.addSelect(tableMvt.getField("IDSOURCE"));
        sel.addSelect(tableMvt.getField("ID_MOUVEMENT_PERE"));
        sel.addSelect(tableMvt.getField("ID_PIECE"));
        sel.addJoin("LEFT", tableMvt.getField("ID_PIECE"));
        sel.addSelect(sel.getAlias(tablePiece.getField("NOM")));
        Where w = new Where((FieldRef)tableMvt.getField("ID_MOUVEMENT_PERE"), "=", tableMvt.getUndefinedID());
        w = w.and(new Where((FieldRef)tableMvt.getField("SOURCE"), "=", (Object)"SAISIE_VENTE_FACTURE"));
        w = w.and(new Where(sel.getAlias(tablePiece.getField("NOM")), "LIKE", (Object)"%Saisie vente facture%"));
        sel.setWhere(w);
        System.err.println(sel.asString());
        List rows = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, tableMvt));
        for (SQLRow sqlRow : rows) {
            SQLRow rowPiece = sqlRow.getForeignRow("ID_PIECE");
            String nom = rowPiece.getString("NOM");
            if (!nom.startsWith("Saisie vente facture")) continue;
            SQLRowValues rowVals = rowPiece.asRowValues();
            String nomNew = nom.replaceAll("Saisie vente facture", "Fact. vente");
            rowVals.put("NOM", nomNew);
            try {
                rowVals.update();
            }
            catch (SQLException exn) {
                exn.printStackTrace();
            }
        }
    }
}

