/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.mail;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.customerrelationship.mail.ValueListener;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.core.edm.AttachmentPanel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class EmailTemplate {
    private String name;
    private String title;
    private String text;
    private boolean isDefault;
    private String dateFormat;
    private Set<Attachment> attachments;

    public EmailTemplate(String name, String title, String text, Boolean isDefault, String dateFormat) {
        this(name, title, text, isDefault, dateFormat, Collections.emptySet());
    }

    public EmailTemplate(String name, String title, String text, Boolean isDefault, String dateFormat, Set<Attachment> attachements) {
        this.name = name;
        this.title = title;
        this.text = text;
        this.isDefault = isDefault;
        this.dateFormat = dateFormat;
        this.attachments = attachements;
    }

    public static List<EmailTemplate> getAllForTable(DBRoot root, String tableName) {
        ArrayList<EmailTemplate> result = new ArrayList<EmailTemplate>();
        SQLSelect selF = new SQLSelect();
        SQLTable tFamilleArticle = root.getTable("MODELE_EMAIL");
        selF.addSelect(tFamilleArticle.getKey());
        selF.addSelect(tFamilleArticle.getField("NOM"));
        selF.addSelect(tFamilleArticle.getField("TITRE"));
        selF.addSelect(tFamilleArticle.getField("TEXTE"));
        selF.addSelect(tFamilleArticle.getField("PAR_DEFAUT"));
        selF.addSelect(tFamilleArticle.getField("FORMAT_DATE"));
        selF.setWhere(new Where((FieldRef)tFamilleArticle.getField("TABLE_NAME"), "=", (Object)tableName));
        List<SQLRow> lF = SQLRowListRSH.execute(selF);
        for (SQLRow sqlRow : lF) {
            Set<Attachment> a;
            if (tFamilleArticle.contains("ATTACHMENTS")) {
                AttachmentPanel panel = new AttachmentPanel(sqlRow);
                a = panel.getAttachements();
            } else {
                a = Collections.emptySet();
            }
            result.add(new EmailTemplate(sqlRow.getString("NOM"), sqlRow.getString("TITRE"), sqlRow.getString("TEXTE"), sqlRow.getBoolean("PAR_DEFAUT"), sqlRow.getString("FORMAT_DATE"), a));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public Set<Attachment> getAttachments() {
        return this.attachments;
    }

    public static void askTemplate(Component parent, DBRoot root, String tableName, final ValueListener listener) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        List<EmailTemplate> templates = EmailTemplate.getAllForTable(root, tableName);
        if (templates.isEmpty()) {
            listener.valueSelected(null);
            return;
        }
        if (templates.size() == 1) {
            listener.valueSelected(templates.get(0));
            return;
        }
        Collections.sort(templates, new Comparator<EmailTemplate>(){

            @Override
            public int compare(EmailTemplate o1, EmailTemplate o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        final JDialog dialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(parent), "Mod\u00e8le \u00e0 utiliser", true);
        final JList<EmailTemplate> list = new JList<EmailTemplate>(templates.toArray(new EmailTemplate[0]));
        list.setSelectionMode(0);
        int i = 0;
        while (i < templates.size()) {
            EmailTemplate t = templates.get(i);
            if (t.isDefault) {
                list.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        list.setFixedCellHeight((int)((double)new JLabel((String)"t").getPreferredSize().height * 1.5));
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                EmailTemplate t = (EmailTemplate)value;
                JLabel l = (JLabel)super.getListCellRendererComponent(list, t.getName(), index, isSelected, cellHasFocus);
                if (t.isDefault) {
                    l.setFont(l.getFont().deriveFont(1));
                } else {
                    l.setFont(l.getFont().deriveFont(0));
                }
                return l;
            }
        });
        list.setMinimumSize(new Dimension(300, 200));
        list.setPreferredSize(new Dimension(300, 200));
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(list, "Center");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2));
        JButton button = new JButton("Valider");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.valueSelected(list.getSelectedValue());
                dialog.dispose();
            }
        });
        p.add(button);
        contentPane.add((Component)p, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }
}

