/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.report;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercial;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercialCreator;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercialPDF;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;

public class ReportingCommercialPanel
extends JPanel {
    public ReportingCommercialPanel(final DBRoot root) {
        super(new GridBagLayout());
        JLabel labelCom = new JLabel("P\u00e9riode du ");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)labelCom, c);
        ++c.gridx;
        final JDate dateDeb = new JDate();
        this.add((Component)dateDeb, c);
        ++c.gridx;
        JLabel labelYear = new JLabel("au");
        final JDate dateFin = new JDate();
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        dateDeb.setValue(cal.getTime());
        this.add((Component)labelYear, c);
        ++c.gridx;
        this.add((Component)dateFin, c);
        cal.set(2, 11);
        cal.set(5, 31);
        dateFin.setValue(cal.getTime());
        final JButton buttonValid = new JButton(new AbstractAction("Valider"){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        ReportingCommercialCreator creator = new ReportingCommercialCreator(dateDeb.getValue(), dateFin.getValue(), root);
                        ArrayList<ReportingCommercial> list = new ArrayList<ReportingCommercial>(creator.getValues());
                        ReportingCommercialPDF reporting = new ReportingCommercialPDF(list);
                        try {
                            File file = File.createTempFile("ReportingCommerical", ".pdf");
                            reporting.export(file);
                            Desktop.getDesktop().open(file);
                        }
                        catch (IOException e) {
                            ExceptionHandler.handle("Erreur lors de la cration du fichier", e);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Frame frame = (Frame)SwingUtilities.getRoot(ReportingCommercialPanel.this);
                                if (frame != null) {
                                    frame.dispose();
                                }
                            }
                        });
                    }
                }.start();
            }
        });
        ++c.gridx;
        this.add((Component)buttonValid, c);
        dateDeb.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                buttonValid.setEnabled(dateDeb.getValue() != null && dateFin.getValue() != null);
            }
        });
        dateFin.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                buttonValid.setEnabled(dateDeb.getValue() != null && dateFin.getValue() != null);
            }
        });
    }
}

