/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.report;

import com.ibm.icu.text.SimpleDateFormat;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercial;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercialItem;

public class ReportingCommercialPDF {
    private final List<ReportingCommercial> items;

    public ReportingCommercialPDF(List<ReportingCommercial> items) {
        this.items = new ArrayList<ReportingCommercial>(items);
        Collections.sort(this.items, new Comparator<ReportingCommercial>(){

            @Override
            public int compare(ReportingCommercial o1, ReportingCommercial o2) {
                return o2.getTotal().compareTo(o1.getTotal());
            }
        });
    }

    public static void main(String[] args) throws IOException {
        ArrayList<ReportingCommercial> list = new ArrayList<ReportingCommercial>();
        Calendar c = Calendar.getInstance();
        Date d1 = c.getTime();
        c.add(2, 50);
        Date d2 = c.getTime();
        int i = 0;
        while (i < 5) {
            ReportingCommercial r = new ReportingCommercial("commercial " + i, d1, d2);
            int j = 0;
            while (j < i * 5) {
                ReportingCommercialItem item = new ReportingCommercialItem("client " + j);
                item.addCA(BigDecimal.valueOf((float)j * 12345.78f));
                r.add(item);
                ++j;
            }
            list.add(r);
            ++i;
        }
        File file = new File("out.pdf");
        ReportingCommercialPDF pdf = new ReportingCommercialPDF(list);
        pdf.export(file);
        Desktop.getDesktop().open(file);
    }

    public void export(File file) throws IOException {
        try {
            Document document = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.open();
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            DecimalFormat decimalFormat = new DecimalFormat("###,###,##0.00");
            DecimalFormatSymbols formatSymbols = decimalFormat.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(' ');
            formatSymbols.setDecimalSeparator(',');
            decimalFormat.setDecimalFormatSymbols(formatSymbols);
            Font fontHeader = new Font(1, 11.0f, 1);
            fontHeader.setColor(Color.WHITE);
            Font normal = new Font(1, 10.0f, 0);
            Font fontTitle = new Font(1, 18.0f, 1);
            Font fontInfo = new Font(1, 11.0f, 0);
            Color backgroundColor = new Color(57, 115, 157);
            Color cellBackgroundColor = new Color(225, 236, 244);
            for (ReportingCommercial reporting : this.items) {
                ArrayList<ReportingCommercialItem> rItems = new ArrayList<ReportingCommercialItem>(reporting.getItems());
                Collections.sort(rItems, new Comparator<ReportingCommercialItem>(){

                    @Override
                    public int compare(ReportingCommercialItem o1, ReportingCommercialItem o2) {
                        return o2.getCa().compareTo(o1.getCa());
                    }
                });
                document.add((Element)new Paragraph("Chiffre d'affaires", fontTitle));
                document.add((Element)new Paragraph("Commercial : " + reporting.getCommercial(), fontInfo));
                document.add((Element)new Paragraph("P\u00e9riode : du " + df.format(reporting.getDebut()) + " au " + df.format(reporting.getFin()), fontInfo));
                if (rItems.isEmpty()) {
                    document.add((Element)new Paragraph("\n"));
                    document.add((Element)new Paragraph("\n"));
                    Font fontInfo2 = new Font(1, 13.0f, 2);
                    fontInfo2.setColor(Color.GRAY);
                    document.add((Element)new Paragraph("Aucune donn\u00e9e.", fontInfo2));
                } else {
                    document.add((Element)new Paragraph("Total : " + decimalFormat.format(reporting.getTotal()) + " \u20ac HT", fontInfo));
                    document.add((Element)new Paragraph("\n"));
                    PdfPTable table = new PdfPTable(2);
                    table.setWidthPercentage(100.0f);
                    table.setWidths(new float[]{800.0f, 160.0f});
                    PdfPCell c1 = new PdfPCell(new Phrase("Clients", fontHeader));
                    c1.setBackgroundColor(backgroundColor);
                    c1.setBorder(0);
                    c1.setHorizontalAlignment(0);
                    c1.setVerticalAlignment(5);
                    c1.setPaddingBottom(7.0f);
                    c1.setPaddingLeft(6.0f);
                    table.addCell(c1);
                    PdfPCell c2 = new PdfPCell(new Phrase("C.A. H.T.", fontHeader));
                    c2.setBackgroundColor(backgroundColor);
                    c2.setBorder(0);
                    c2.setHorizontalAlignment(1);
                    c2.setVerticalAlignment(5);
                    c2.setPaddingBottom(7.0f);
                    c2.setPaddingLeft(6.0f);
                    table.addCell(c2);
                    table.setHeaderRows(1);
                    boolean pair = true;
                    for (ReportingCommercialItem rItem : rItems) {
                        PdfPCell col1 = new PdfPCell(new Phrase(rItem.getClient(), normal));
                        col1.setBorder(0);
                        col1.setHorizontalAlignment(0);
                        col1.setVerticalAlignment(1);
                        col1.setPaddingBottom(5.0f);
                        col1.setPaddingLeft(6.0f);
                        PdfPCell col2 = new PdfPCell(new Phrase(decimalFormat.format(rItem.getCa()), normal));
                        col2.setHorizontalAlignment(2);
                        col2.setBorder(0);
                        if (pair) {
                            col1.setBackgroundColor(cellBackgroundColor);
                            col2.setBackgroundColor(cellBackgroundColor);
                        }
                        table.addCell(col1);
                        table.addCell(col2);
                        boolean bl = pair = !pair;
                    }
                    document.add((Element)table);
                }
                document.newPage();
            }
            document.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

