/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.ContactSQLElementBase;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;

public abstract class ComptaContactSQLElement
extends ContactSQLElementBase {
    protected ComptaContactSQLElement(String tableName) {
        super(tableName);
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComptaContactSQLElement.this.sendMail(IListe.get(e).getSelectedRows());
            }
        }, true, "customerrelationship.customer.email.send");
        action.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(action);
    }

    public static class ContactAdministratifSQLElement
    extends ComptaContactSQLElement {
        public ContactAdministratifSQLElement() {
            super("CONTACT_ADMINISTRATIF");
        }
    }

    public static class ContactFournisseurSQLElement
    extends ComptaContactSQLElement {
        public ContactFournisseurSQLElement() {
            super("CONTACT_FOURNISSEUR");
        }
    }

    public static class ContactSQLElement
    extends ComptaContactSQLElement {
        public ContactSQLElement() {
            super("CONTACT");
        }

        @Override
        protected void _initComboRequest(ComboSQLRequest req) {
            super._initComboRequest(req);
            UserRights rights = UserRightsManager.getCurrentUserRights();
            if (!rights.haveRight(ComptaSQLConfElement.NON_RESTREINT_PAR_COMMERCIAL_RIGHT)) {
                req.putWhere(ComptaSQLConfElement.NON_RESTREINT_PAR_COMMERCIAL_RIGHT, this.getWhereCommercial());
            }
        }

        @Override
        protected synchronized void _initTableSource(SQLTableModelSource res) {
            super._initTableSource(res);
            UserRights rights = UserRightsManager.getCurrentUserRights();
            if (!rights.haveRight(ComptaSQLConfElement.NON_RESTREINT_PAR_COMMERCIAL_RIGHT)) {
                res.getReq().putWhere(ComptaSQLConfElement.NON_RESTREINT_PAR_COMMERCIAL_RIGHT, this.getWhereCommercial());
            }
        }

        private Where getWhereCommercial() {
            SQLRow row = this.getTable().getDBRoot().findTable("USER_COMMON").getRow(UserManager.getInstance().getCurrentUser().getId());
            SQLTable tableCommercial = this.getTable().getTable("COMMERCIAL");
            Collection rows = row.getReferentRows(tableCommercial.getField("ID_USER_COMMON"));
            Where w = null;
            if (rows.isEmpty()) {
                w = Where.FALSE;
            } else {
                for (SQLRow sqlRow : rows) {
                    SQLField field = this.getTable().getField("ID_CLIENT");
                    SQLSelect selIDClient = new SQLSelect();
                    selIDClient.addSelect(field.getForeignTable().getKey());
                    selIDClient.setWhere(new Where((FieldRef)field.getForeignTable().getField("ID_COMMERCIAL"), "=", sqlRow.getID()));
                    Where wClient = Where.createRaw(String.valueOf(field.getSQLName().quote()) + " IN (" + selIDClient.asString() + ")", field);
                    w = Where.or(w, wClient);
                }
            }
            return w;
        }
    }

    public static class ContactSalarieSQLElement
    extends ComptaContactSQLElement {
        public ContactSalarieSQLElement() {
            super("CONTACT_SALARIE");
        }
    }
}

