/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.AdresseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.customerrelationship.customer.element.ContactItemTable;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseClientItemTable;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.component.ModeDeReglementSQLComponent;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.VWRowItemView;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;

public class ClientNormalSQLComponent
extends BaseSQLComponent {
    private int idDefaultCompteClient = 1;
    private JCheckBox checkAdrFacturation;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private ElementComboBox boxPays = null;
    private final ElementComboBox boxTarif = new ElementComboBox();
    protected boolean showMdr = true;
    private ElementSQLObject componentPrincipale;
    private ElementSQLObject componentFacturation;
    private AdresseClientItemTable adresseTable = new AdresseClientItemTable();
    private JCheckBox boxGestionAutoCompte;
    private Map<SQLField, JCheckBox> mapCheckLivraison = new HashMap<SQLField, JCheckBox>();
    private JCheckBox boxAffacturage;
    private JCheckBox boxComptant;
    private DeviseField fieldMontantFactMax;
    private ISQLCompteSelector compteSel;
    private SQLRowItemView textNom;
    private final ElementComboBox comboPole = new ElementComboBox();
    private final DecimalFormat format = new DecimalFormat("000");
    private final SQLTable contactTable = Configuration.getInstance().getDirectory().getElement("CONTACT").getTable();
    private ContactItemTable table;
    private final SQLRowValues defaultContactRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.contactTable));
    private SQLRowItemView eltModeRegl;
    private JUniqueTextField textCode;
    private JLabel labelCpt;
    private ModeDeReglementSQLComponent modeReglComp;

    public ClientNormalSQLComponent(SQLElement elt) {
        super(elt);
    }

    @Override
    public void addViews() {
        JPanel addOnPanel;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabel labelRS = new JLabel(this.getLabelFor("FORME_JURIDIQUE"));
        labelRS.setHorizontalAlignment(4);
        SQLTextCombo textType = new SQLTextCombo();
        this.add((Component)labelRS, c);
        ++c.gridx;
        c.weightx = 0.5;
        c.fill = 1;
        DefaultGridBagConstraints.lockMinimumSize(textType);
        this.add((Component)textType, c);
        JLabel labelCode = new JLabel(this.getLabelFor("CODE"));
        labelCode.setHorizontalAlignment(4);
        this.textCode = new JUniqueTextField(){

            @Override
            public String getAutoRefreshNumber() {
                if (ClientNormalSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    return NumerotationAutoSQLElement.getNextNumero(ClientNormalSQLComponent.this.getElement().getClass());
                }
                return null;
            }
        };
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)labelCode, c);
        ++c.gridx;
        c.weightx = 0.5;
        c.gridwidth = 1;
        DefaultGridBagConstraints.lockMinimumSize(this.textCode);
        this.add((Component)this.textCode, c);
        JLabel labelNom = new JLabel("Nom");
        labelNom.setHorizontalAlignment(4);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)labelNom, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.5;
        JTextField nomComp = new JTextField();
        DefaultGridBagConstraints.lockMinimumSize(nomComp);
        this.add((Component)nomComp, c);
        if (this.getTable().getFieldsName().contains("ID_PAYS")) {
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ID_PAYS"), 4), c);
            this.boxPays = new ElementComboBox(true, 25);
            ++c.gridx;
            c.weightx = 0.5;
            this.add((Component)this.boxPays, c);
            this.addView(this.boxPays, "ID_PAYS");
            DefaultGridBagConstraints.lockMinimumSize(this.boxPays);
        }
        if (this.getTable().getFieldsName().contains("LOCALISATION")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            JLabel comp2 = new JLabel(this.getLabelFor("LOCALISATION"));
            comp2.setHorizontalAlignment(4);
            this.add((Component)comp2, c);
            JTextField loc = new JTextField();
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)loc, c);
            this.addView(loc, "LOCALISATION");
        }
        JLabel labelIntraComm = new JLabel("N\u00b0 TVA");
        labelIntraComm.setHorizontalAlignment(4);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)labelIntraComm, c);
        JTextField textNumIntracomm = new JTextField(20);
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textNumIntracomm);
        this.add((Component)textNumIntracomm, c);
        JLabel labelSIREN = new JLabel(this.getLabelFor("SIRET"));
        labelSIREN.setHorizontalAlignment(4);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)labelSIREN, c);
        JTextField textSiren = new JTextField(20);
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textSiren);
        this.add((Component)textSiren, c);
        JLabel responsable = new JLabel(this.getLabelFor("RESPONSABLE"));
        responsable.setHorizontalAlignment(4);
        JTextField textResp = new JTextField();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.add((Component)responsable, c);
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textResp);
        this.add((Component)textResp, c);
        JLabel labelRIB = new JLabel(this.getLabelFor("RIB"));
        labelRIB.setHorizontalAlignment(4);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)labelRIB, c);
        JTextField textRib = new JTextField();
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textRib);
        this.add((Component)textRib, c);
        JLabel labelTel = new JLabel(this.getLabelFor("TEL"));
        labelTel.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelTel, c);
        final JTextField textTel = new JTextField();
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textTel);
        this.add((Component)textTel, c);
        textTel.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClientNormalSQLComponent.this.defaultContactRowVals.put("TEL_DIRECT", textTel.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClientNormalSQLComponent.this.defaultContactRowVals.put("TEL_DIRECT", textTel.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClientNormalSQLComponent.this.defaultContactRowVals.put("TEL_DIRECT", textTel.getText());
            }
        });
        JLabel labelMail = new JLabel("E-mail");
        labelMail.setHorizontalAlignment(4);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)labelMail, c);
        JTextField textMail = new JTextField();
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textMail);
        this.add((Component)textMail, c);
        JLabel labelPortable = new JLabel("N\u00b0 de portable");
        labelPortable.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelPortable, c);
        JTextField textPortable = new JTextField();
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textPortable);
        this.add((Component)textPortable, c);
        JLabel labelFax = new JLabel("N\u00b0 de fax");
        labelFax.setHorizontalAlignment(4);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)labelFax, c);
        final JTextField textFax = new JTextField();
        ++c.gridx;
        c.weightx = 0.5;
        DefaultGridBagConstraints.lockMinimumSize(textFax);
        this.add((Component)textFax, c);
        textFax.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClientNormalSQLComponent.this.defaultContactRowVals.put("FAX", textFax.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClientNormalSQLComponent.this.defaultContactRowVals.put("FAX", textFax.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClientNormalSQLComponent.this.defaultContactRowVals.put("FAX", textFax.getText());
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Adresses", this.createAdressesComponent());
        tabs.addTab("Contacts", this.createContactComponent());
        JPanel pReglement = this.createReglementComponent();
        if (this.showMdr) {
            tabs.addTab("Mode de r\u00e8glement", pReglement);
        }
        tabs.addTab("Comptabilit\u00e9", this.createComptabiliteComponent());
        tabs.setMinimumSize(new Dimension(tabs.getPreferredSize().width, tabs.getPreferredSize().height));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        this.add((Component)tabs, c);
        c.fill = 2;
        c.gridwidth = 1;
        c.weighty = 0.0;
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            JLabel tarifSep = new JLabel("Tarif sp\u00e9cial \u00e0 appliquer");
            c.gridwidth = 0;
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)tarifSep, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ID_TARIF"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 0;
            this.add((Component)this.boxTarif, c);
            this.addView(this.boxTarif, "ID_TARIF");
        }
        if (this.getTable().getFieldsName().contains("ID_LANGUE")) {
            JLabel langueSep = new JLabel("Langue \u00e0 appliquer sur les documents");
            c.gridwidth = 0;
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)langueSep, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ID_LANGUE"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 0;
            final ElementComboBox boxLangue = new ElementComboBox();
            this.add((Component)boxLangue, c);
            this.addView(boxLangue, "ID_LANGUE");
            this.boxPays.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow row = ClientNormalSQLComponent.this.boxPays.getSelectedRow();
                    if (row != null) {
                        ClientNormalSQLComponent.this.boxTarif.setValue(row.getInt("ID_TARIF"));
                        boxLangue.setValue(row.getInt("ID_LANGUE"));
                    }
                }
            });
        }
        if ((addOnPanel = this.getAddOnPanel(this)) != null) {
            ++c.gridy;
            this.add((Component)addOnPanel, c);
        }
        JLabel infosSep = new JLabel(this.getLabelFor("INFOS"));
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)infosSep, c);
        ITextArea textInfos = new ITextArea();
        ++c.gridy;
        c.weighty = 0.3;
        c.fill = 1;
        this.add((Component)textInfos, c);
        this.checkAdrFacturation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = ClientNormalSQLComponent.this.checkAdrFacturation.isSelected();
                ClientNormalSQLComponent.this.componentFacturation.setEditable(!b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                ClientNormalSQLComponent.this.componentFacturation.setCreated(!b);
            }
        });
        this.addSQLObject(textType, "FORME_JURIDIQUE");
        this.addView(nomComp, "NOM", (Object)"required");
        this.textNom = this.getView(nomComp);
        this.addSQLObject(this.textCode, "CODE");
        this.addSQLObject(textFax, "FAX");
        this.addSQLObject(textSiren, "SIRET");
        this.addSQLObject(textMail, "MAIL");
        this.addSQLObject(textTel, "TEL");
        this.addSQLObject(textPortable, "TEL_P");
        this.addSQLObject(textNumIntracomm, "NUMERO_TVA");
        this.addSQLObject(textResp, "RESPONSABLE");
        this.addSQLObject(textInfos, "INFOS");
        this.addSQLObject((JComponent)this.compteSel, "ID_COMPTE_PCE");
    }

    private Component createAdressesComponent() {
        JTabbedPane tabbedAdresse = new JTabbedPane(){

            @Override
            public void insertTab(String title, Icon icon, Component component, String tip, int index) {
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(false);
                }
                super.insertTab(title, icon, component, tip, index);
            }
        };
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.addView("ID_ADRESSE", "required;notdecorated;noseparator");
        this.componentPrincipale = (ElementSQLObject)this.getView("ID_ADRESSE");
        this.componentPrincipale.setOpaque(false);
        tabbedAdresse.add(this.getLabelFor("ID_ADRESSE"), this.componentPrincipale);
        tabbedAdresse.setOpaque(false);
        JPanel panelFacturation = new JPanel(new GridBagLayout());
        panelFacturation.setOpaque(false);
        GridBagConstraints cPanelF = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 1, 2, 1), 0, 0);
        this.addView("ID_ADRESSE_F", "notdecorated;noseparator");
        this.componentFacturation = (ElementSQLObject)this.getView("ID_ADRESSE_F");
        this.componentFacturation.setOpaque(false);
        ((AdresseSQLComponent)this.componentFacturation.getSQLChild()).setDestinataireVisible(true);
        panelFacturation.add((Component)this.componentFacturation, cPanelF);
        this.checkAdrFacturation = new JCheckBox("Adresse de facturation identique \u00e0 la principale");
        this.checkAdrFacturation.setOpaque(false);
        ++cPanelF.gridy;
        panelFacturation.add((Component)this.checkAdrFacturation, cPanelF);
        tabbedAdresse.add(this.getLabelFor("ID_ADRESSE_F"), panelFacturation);
        this.checkAdrFacturation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = ClientNormalSQLComponent.this.checkAdrFacturation.isSelected();
                ClientNormalSQLComponent.this.componentFacturation.setEditable(!b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                ClientNormalSQLComponent.this.componentFacturation.setCreated(!b);
            }
        });
        this.checkAdrFacturation.setSelected(true);
        Set<SQLField> fieldsAdr = this.getTable().getForeignKeys("ADRESSE");
        ArrayList<SQLField> fieldsAdrOrder = new ArrayList<SQLField>(fieldsAdr);
        Collections.sort(fieldsAdrOrder, new Comparator<SQLField>(){

            @Override
            public int compare(SQLField o1, SQLField o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int val = 1;
        for (SQLField sqlField : fieldsAdrOrder) {
            String fieldName = sqlField.getName();
            if (!fieldName.startsWith("ID_ADRESSE_L")) continue;
            JPanel panelLivraison = new JPanel(new GridBagLayout());
            panelLivraison.setOpaque(false);
            GridBagConstraints cPanelL = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 1, 2, 1), 0, 0);
            this.addView(fieldName, "notdecorated;noseparator");
            final ElementSQLObject componentLivraison = (ElementSQLObject)this.getView(fieldName);
            componentLivraison.setOpaque(false);
            ((AdresseSQLComponent)componentLivraison.getSQLChild()).setDestinataireVisible(true);
            panelLivraison.add((Component)componentLivraison, cPanelL);
            final JCheckBox checkAdrLivraison = new JCheckBox("Adresse de livraison identique \u00e0 l'adresse principale");
            checkAdrLivraison.setOpaque(false);
            ++cPanelL.gridy;
            panelLivraison.add((Component)checkAdrLivraison, cPanelL);
            tabbedAdresse.add(String.valueOf(this.getLabelFor(fieldName)) + (val == 1 ? "" : " " + val), panelLivraison);
            ++val;
            checkAdrLivraison.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean b = checkAdrLivraison.isSelected();
                    componentLivraison.setEditable(!b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                    componentLivraison.setCreated(!b);
                }
            });
            checkAdrLivraison.setSelected(true);
            this.mapCheckLivraison.put(sqlField, checkAdrLivraison);
        }
        String labelAdrSuppl = "Adresses suppl\u00e9mentaires";
        tabbedAdresse.add(labelAdrSuppl, this.adresseTable);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        return tabbedAdresse;
    }

    private JPanel createContactComponent() {
        this.table = new ContactItemTable(this.defaultContactRowVals);
        this.table.setPreferredSize(new Dimension(this.table.getSize().width, 150));
        this.table.setOpaque(false);
        return this.table;
    }

    private JPanel createReglementComponent() {
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        this.eltModeRegl = this.getView("ID_MODE_REGLEMENT");
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        ElementSQLObject comp = (ElementSQLObject)this.eltModeRegl.getComp();
        this.modeReglComp = (ModeDeReglementSQLComponent)comp.getSQLChild();
        JLabelBold label = new JLabelBold(this.getLabelFor("ID_MODE_REGLEMENT"));
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        p.add((Component)label, c);
        ++c.gridy;
        c.gridx = 0;
        comp.setOpaque(false);
        p.add((Component)comp, c);
        return p;
    }

    private Component createComptabiliteComponent() {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.compteSel = new ISQLCompteSelector(true);
        this.boxGestionAutoCompte = new JCheckBox("Gestion Automatique des comptes");
        JLabelBold sepCompte = new JLabelBold("Compte associ\u00e9");
        this.labelCpt = new JLabel(this.getLabelFor("ID_COMPTE_PCE"));
        if (!Boolean.valueOf(DefaultNXProps.getInstance().getProperty("HideCompteClient")).booleanValue()) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 0;
            p.add((Component)sepCompte, c);
            c.gridwidth = 1;
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            p.add((Component)this.labelCpt, c);
            c.gridwidth = 0;
            ++c.gridx;
            c.weightx = 1.0;
            p.add((Component)this.compteSel, c);
            this.boxGestionAutoCompte.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientNormalSQLComponent.this.setCompteVisible(!ClientNormalSQLComponent.this.boxGestionAutoCompte.isSelected() || ClientNormalSQLComponent.this.getSelectedID() > 1);
                }
            });
            c.gridwidth = 1;
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            p.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE_SERVICE")), c);
            c.gridwidth = 0;
            ++c.gridx;
            c.weightx = 1.0;
            ISQLCompteSelector compteSelService = new ISQLCompteSelector();
            p.add((Component)compteSelService, c);
            this.addView((JComponent)compteSelService, "ID_COMPTE_PCE_SERVICE");
        }
        return p;
    }

    private void setCompteVisible(boolean b) {
        this.labelCpt.setVisible(b);
        this.compteSel.setVisible(b);
    }

    @Override
    public void update() {
        super.update();
        int selectedID = this.getSelectedID();
        this.table.updateField("ID_CLIENT", selectedID);
        this.adresseTable.updateField("ID_CLIENT", selectedID);
        if (this.boxGestionAutoCompte.isSelected()) {
            SQLRow row = this.getTable().getRow(selectedID);
            if (row.getInt("ID_COMPTE_PCE") <= 1) {
                this.createCompteClientAuto(selectedID);
            } else {
                int answer;
                String compte;
                SQLRow rowCpt = row.getForeignRow("ID_COMPTE_PCE");
                String num = rowCpt.getString("NUMERO");
                String initialClient = "";
                String text = this.getNameValue();
                if (text != null && text.trim().length() > 1) {
                    initialClient = String.valueOf(initialClient) + text.trim().toUpperCase().charAt(0);
                }
                if (!num.startsWith(compte = "411" + initialClient) && (answer = JOptionPane.showConfirmDialog(null, "Voulez vous changer le compte associ\u00e9 au client, le nom a chang\u00e9?", "Modification compte client", 0)) == 0) {
                    this.createCompteClientAuto(selectedID);
                }
            }
        }
    }

    private String getNameValue() {
        return (String)((VWRowItemView)this.textNom).getWrapper().getValue();
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        for (SQLField f : this.mapCheckLivraison.keySet()) {
            this.mapCheckLivraison.get(f).setSelected(r == null || !r.getFields().contains(f.getName()) || r.isForeignEmpty(f.getName()));
        }
        this.checkAdrFacturation.setSelected(r == null || !r.getFields().contains("ID_ADRESSE_F") || r.isForeignEmpty("ID_ADRESSE_F"));
        if (r != null) {
            this.table.insertFrom("ID_CLIENT", r.asRowValues());
            this.adresseTable.insertFrom("ID_CLIENT", r.getID());
            this.defaultContactRowVals.put("TEL_DIRECT", r.getString("TEL"));
            this.defaultContactRowVals.put("FAX", r.getString("FAX"));
        }
    }

    private void createCompteClientFromCodeAuto(int idClient) {
        SQLRow rowClient = this.getTable().getRow(idClient);
        if (rowClient.isForeignEmpty("ID_COMPTE_PCE")) {
            this.createCompteClientAuto(idClient);
        }
    }

    private void createCompteClientAuto(int idClient) {
        SQLRowValues rowVals = this.getTable().getRow(idClient).createEmptyUpdateRow();
        String initialClient = "";
        String text = this.getNameValue();
        if (text != null && text.trim().length() > 1) {
            initialClient = String.valueOf(initialClient) + text.trim().toUpperCase().charAt(0);
        }
        String compte = "411" + initialClient;
        SQLTable table = Configuration.getInstance().getDirectory().getElement("COMPTE_PCE").getTable();
        SQLSelect selCompte = new SQLSelect();
        selCompte.addSelectFunctionStar("COUNT");
        selCompte.setArchivedPolicy(SQLSelect.BOTH);
        selCompte.setWhere(new Where((FieldRef)table.getField("NUMERO"), "LIKE", (Object)(String.valueOf(compte) + "%")));
        System.err.println(selCompte.asString());
        Object o = Configuration.getInstance().getBase().getDataSource().executeScalar(selCompte.asString());
        int nb = 0;
        if (o != null) {
            Long i = (Long)o;
            nb = i.intValue();
        }
        int idCpt = ComptePCESQLElement.getId(String.valueOf(compte) + this.format.format(nb), text);
        rowVals.put("ID_COMPTE_PCE", idCpt);
        try {
            rowVals.update();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int insert(SQLRow order) {
        SQLPreferences prefs;
        if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()).equalsIgnoreCase(this.textCode.getText().trim())) {
            SQLRowValues rowVals = new SQLRowValues(this.tableNum);
            SQLRow rowNumAuto = this.tableNum.getRow(2);
            if (rowNumAuto.getObject("CLIENT_START") != null) {
                int val = rowNumAuto.getInt("CLIENT_START");
                rowVals.put("CLIENT_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        int id = super.insert(order);
        this.table.updateField("ID_CLIENT", id);
        this.adresseTable.updateField("ID_CLIENT", id);
        if (this.boxGestionAutoCompte.isSelected()) {
            this.createCompteClientAuto(id);
        }
        if ((prefs = new SQLPreferences(this.getTable().getDBRoot())).getBoolean(GestionCommercialeGlobalPreferencePanel.COMPTE_CLIENT_AUTO, Boolean.FALSE)) {
            this.createCompteClientFromCodeAuto(id);
        }
        return id;
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put("MARCHE_PUBLIC", Boolean.TRUE);
        vals.put("CODE", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow((boolean)true);
            SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
            if (r.getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(r, null);
                System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                vals.put("ID_MODE_REGLEMENT", (Object)rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
        SQLRow rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte).getRowFromId(2);
        this.idDefaultCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT");
        if (this.idDefaultCompteClient <= 1) {
            try {
                this.idDefaultCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("ID_COMPTE_PCE", this.idDefaultCompteClient);
        return vals;
    }

    public ContactItemTable getContactTable() {
        return this.table;
    }

    protected JPanel getAddOnPanel(BaseSQLComponent c) {
        return null;
    }
}

