/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class NumericTextField
extends JTextField
implements ValueWrapper<BigDecimal>,
Documented,
RowItemViewComponent {
    private SQLField field;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private boolean gained = false;
    private boolean mousePressed;
    private String initialText;

    public NumericTextField() {
        this(15);
    }

    public NumericTextField(int columns) {
        super(columns);
        this.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                NumericTextField.this.textModified();
            }
        });
        this.init();
    }

    protected void textModified() {
        this.supp.firePropertyChange("value", null, this.getValue());
    }

    @Override
    public void init(SQLRowItemView v) {
        this.field = v.getFields().get(0);
    }

    private void init() {
        NumericTextField.addFilteringKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                NumericTextField.this.gained = true;
                NumericTextField.this.initialText = NumericTextField.this.getText();
                if (!NumericTextField.this.mousePressed) {
                    NumericTextField.this.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NumericTextField.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (NumericTextField.this.gained && NumericTextField.this.getSelectedText() == null) {
                    NumericTextField.this.selectAll();
                }
                NumericTextField.this.gained = false;
                NumericTextField.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    NumericTextField.this.setValue(NumericTextField.this.initialText);
                    NumericTextField.this.selectAll();
                }
            }
        });
    }

    public static void addFilteringKeyListener(final NumericTextField textField) {
        textField.addKeyListener(new KeyAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = textField.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (textField.getSelectedText() != null) return;
                    if (textField.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (textField.getText().substring(pointPosition).length() <= 6) {
                        return;
                    }
                }
                if (keychar == '.' && textField.getText().indexOf(46) < 0) {
                    return;
                }
                if (textField.getCaretPosition() > 0 && textField.getCaretPosition() == textField.getText().length()) {
                    return;
                }
                keyEvent.consume();
            }
        });
    }

    @Override
    public final void resetValue() {
        this.setValue((BigDecimal)null);
    }

    @Override
    public void setValue(BigDecimal val) {
        this.setValue(val == null ? "" : val.toString());
    }

    @Override
    private final void setValue(String val) {
        if (!this.getText().equals(val)) {
            this.setText(val);
        }
    }

    public void setBold() {
        this.setFont(this.getFont().deriveFont(1));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public BigDecimal getValue() {
        if (this.getText().trim().length() == 0) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(this.getText().trim());
        }
        catch (NumberFormatException ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NumericTextField.this.setText("0");
                }
            });
            return BigDecimal.ZERO;
        }
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public SQLField getField() {
        return this.field;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public String getDocId() {
        return "";
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }
}

