/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openconcerto.map.model.Ville;
import org.openconcerto.map.ui.ITextComboVilleViewer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;

public class ITextComboVilleTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private ITextComboVilleViewer comboBox = new ITextComboVilleViewer();

    public ITextComboVilleTableCellEditor() {
        this.comboBox.setButtonVisible(false);
    }

    public void addKeyListener(KeyListener l) {
        this.comboBox.addKeyListener(l);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        RowValuesTable rowValuesTable = (RowValuesTable)table;
        SQLRowValues rowVals = rowValuesTable.getRowValuesTableModel().getRowValuesAt(row);
        String v = rowVals.getString("VILLE");
        String code = rowVals.getString("CODE_POSTAL");
        Ville ville = Ville.getVilleFromVilleEtCode((String)(String.valueOf(v) + " (" + code + ")"));
        this.comboBox.setValue(ville);
        this.comboBox.grabFocus();
        return this.comboBox;
    }
}

