/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.StringUtils;

public class DeviseNumericRemiseCellEditor
extends DeviseNumericCellEditor
implements MouseListener {
    private BigDecimal ht = BigDecimal.ZERO;
    private BigDecimal ttc = BigDecimal.ZERO;

    public DeviseNumericRemiseCellEditor(SQLField field) {
        super(field);
        this.textField.addMouseListener(this);
    }

    public void setHT(BigDecimal d) {
        this.ht = d;
    }

    public void setTTC(BigDecimal d) {
        this.ttc = d;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.textField.getText().trim().length() > 0 && e.getButton() == 3) {
            JPopupMenu menuDroit = new JPopupMenu();
            AbstractAction htToPercent = new AbstractAction("Convertir le montant HT en %"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BigDecimal prixHTRemise = StringUtils.getBigDecimalFromUserText(DeviseNumericRemiseCellEditor.this.textField.getText());
                    if (prixHTRemise != null) {
                        BigDecimal divide = prixHTRemise.divide(DeviseNumericRemiseCellEditor.this.ht, DecimalUtils.HIGH_PRECISION).movePointRight(2);
                        divide = divide.setScale(DeviseNumericRemiseCellEditor.this.precision, RoundingMode.HALF_UP);
                        DeviseNumericRemiseCellEditor.this.textField.setText(divide.toString());
                    }
                }
            };
            htToPercent.setEnabled(this.ht.signum() != 0);
            menuDroit.add(htToPercent);
            AbstractAction ttcToPercent = new AbstractAction("Convertir le montant TTC en %"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BigDecimal prixTTCRemise = StringUtils.getBigDecimalFromUserText(DeviseNumericRemiseCellEditor.this.textField.getText());
                    if (prixTTCRemise != null) {
                        BigDecimal divide = prixTTCRemise.divide(DeviseNumericRemiseCellEditor.this.ttc, DecimalUtils.HIGH_PRECISION).movePointRight(2);
                        divide = divide.setScale(DeviseNumericRemiseCellEditor.this.precision, RoundingMode.HALF_UP);
                        DeviseNumericRemiseCellEditor.this.textField.setText(divide.toString());
                    }
                }
            };
            ttcToPercent.setEnabled(this.ttc.signum() != 0);
            menuDroit.add(ttcToPercent);
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

