/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.util.Collection;
import org.openconcerto.erp.core.common.element.SocieteSQLConfElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;

public abstract class ComptaSQLConfElement
extends SocieteSQLConfElement {
    private static DBRoot baseSociete;
    public static String NON_RESTREINT_PAR_COMMERCIAL_RIGHT;

    static {
        NON_RESTREINT_PAR_COMMERCIAL_RIGHT = "NON_RESTREINT_PAR_COMMERCIAL";
    }

    private static DBRoot getBaseSociete() {
        if (baseSociete == null) {
            baseSociete = ((ComptaBasePropsConfiguration)Configuration.getInstance()).getRootSociete();
        }
        return baseSociete;
    }

    protected static SQLTable findTable(String tableName) {
        return ComptaSQLConfElement.getBaseSociete().findTable(tableName, true);
    }

    public ComptaSQLConfElement(String tableName, String singular, String plural) {
        this(ComptaSQLConfElement.findTable(tableName), singular, plural);
    }

    public ComptaSQLConfElement(SQLTable table, String singular, String plural) {
        super(table, singular, plural);
    }

    public ComptaSQLConfElement(String tableName) {
        this(tableName, null);
    }

    public ComptaSQLConfElement(String tableName, String code) {
        this(ComptaSQLConfElement.findTable(tableName), code);
    }

    public ComptaSQLConfElement(SQLTable table) {
        this(table, (String)null);
    }

    public ComptaSQLConfElement(SQLTable table, String code) {
        super(table, code);
    }

    public void addCommercialFilter(SQLTableModelSource source, SQLField fieldCommercial) {
        UserRights rights = UserRightsManager.getCurrentUserRights();
        if (!rights.haveRight(NON_RESTREINT_PAR_COMMERCIAL_RIGHT)) {
            source.getReq().putWhere(NON_RESTREINT_PAR_COMMERCIAL_RIGHT, this.getWhereCommercial(fieldCommercial));
        }
    }

    private Where getWhereCommercial(SQLField fieldCommercial) {
        SQLRow row = fieldCommercial.getTable().getDBRoot().findTable("USER_COMMON").getRow(UserManager.getInstance().getCurrentUser().getId());
        Collection rows = row.getReferentRows(fieldCommercial.getForeignTable().getField("ID_USER_COMMON"));
        Where w = null;
        if (rows.isEmpty()) {
            w = Where.FALSE;
        } else {
            for (SQLRow sqlRow : rows) {
                if (fieldCommercial.getTable().getName().equals(this.getTable().getName())) {
                    w = Where.or(w, new Where((FieldRef)fieldCommercial, "=", sqlRow.getID()));
                    continue;
                }
                SQLField field = this.getTable().getField("ID_" + fieldCommercial.getTable().getName());
                SQLSelect selIDClient = new SQLSelect();
                selIDClient.addSelect(fieldCommercial.getTable().getKey());
                selIDClient.setWhere(new Where((FieldRef)fieldCommercial, "=", sqlRow.getID()));
                Where wClient = Where.createRaw(String.valueOf(field.getSQLName().quote()) + " IN (" + selIDClient.asString() + ")", field);
                w = Where.or(w, wClient);
            }
        }
        return w;
    }

    public void addCommercialFilterCombo(ComboSQLRequest req, SQLField fieldCommercial) {
        UserRights rights = UserRightsManager.getCurrentUserRights();
        if (!rights.haveRight(NON_RESTREINT_PAR_COMMERCIAL_RIGHT)) {
            req.putWhere(NON_RESTREINT_PAR_COMMERCIAL_RIGHT, this.getWhereCommercial(fieldCommercial));
        }
    }
}

