/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import org.openconcerto.erp.config.MenuAndActions;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.i18n.TranslationManager;

public class MenuManager {
    private static MenuManager instance = null;
    private MenuAndActions baseMA;
    private MenuAndActions menuAndActions;
    private Group group;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    public static final void setInstance(MenuAndActions baseMA) {
        MenuManager.setInstance(new MenuManager(baseMA));
    }

    public static final synchronized void setInstance(MenuManager mm) {
        instance = mm;
    }

    public static final synchronized MenuManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Not inited");
        }
        return instance;
    }

    public MenuManager(MenuAndActions baseMA) {
        this.baseMA = baseMA;
        this.setMenuAndActions(this.createBaseMenuAndActions());
        assert (this.group != null);
    }

    public final Group getGroup() {
        return this.group;
    }

    public void registerAction(String id, Action a) {
        this.menuAndActions.putAction(a, id, true);
        this.supp.firePropertyChange("actions", null, null);
    }

    public Action getActionForId(String id) {
        return this.menuAndActions.getAction(id);
    }

    public String getLabelForId(String id) {
        return TranslationManager.getInstance().getTranslationForMenu(id);
    }

    public final MenuAndActions createBaseMenuAndActions() {
        return this.baseMA.copy();
    }

    public final MenuAndActions copyMenuAndActions() {
        return this.menuAndActions.copy();
    }

    public synchronized void setMenuAndActions(MenuAndActions menuAndActions) {
        this.menuAndActions = menuAndActions.copy();
        this.supp.firePropertyChange("menuAndActions", null, null);
        this.supp.firePropertyChange("actions", null, null);
        if (!this.menuAndActions.getGroup().equalsDesc(this.group)) {
            Group oldGroup = this.group;
            this.group = this.menuAndActions.getGroup();
            this.group.freeze();
            this.supp.firePropertyChange("group", oldGroup, this.getGroup());
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.supp.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.supp.removePropertyChangeListener(listener);
    }
}

