/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public class Benchmark {
    public static void main(String[] args) throws IOException {
        Benchmark b = new Benchmark();
        b.testWriteHD();
        System.err.println(b.testCPU());
    }

    public String testDB() {
        IResultSetHandler h = new IResultSetHandler(new ResultSetHandler(){

            @Override
            public Object handle(ResultSet arg0) throws SQLException {
                return null;
            }
        }, false, false);
        long t1 = System.currentTimeMillis();
        int c = 0;
        SQLSelect s = new SQLSelect();
        SQLTable t = ComptaPropsConfiguration.getInstanceCompta().getRoot().getDBSystemRoot().findTable("FWK_SCHEMA_METADATA");
        s.addSelect(t.getField("NAME"));
        SQLDataSource dataSource = ComptaPropsConfiguration.getInstanceCompta().getRoot().getDBSystemRoot().getDataSource();
        int i = 0;
        while (i < 1000000) {
            String sql = s.asString();
            dataSource.execute(sql, h);
            long t2 = System.currentTimeMillis();
            if (t2 > t1 + 2000L) {
                c = i;
                break;
            }
            ++i;
        }
        return String.valueOf(c / 2) + " req/s";
    }

    public String testCPU() {
        long t0 = System.currentTimeMillis();
        double[] b = new double[0x3200000];
        int i = 0;
        while (i < b.length) {
            b[i] = i * 456;
            ++i;
        }
        int k = 0;
        while (k < 10) {
            int i2 = k;
            while (i2 < b.length - 2) {
                b[i2] = b[i2] + b[i2 + 1] + 1.0 / b[i2 + 2];
                ++i2;
            }
            ++k;
        }
        long t1 = System.currentTimeMillis();
        long time = t1 - t0;
        double speed = (long)b.length / time;
        return String.valueOf(Math.round(speed / 100.0)) + " R/s";
    }

    public String testWriteHD() throws IOException {
        long t0 = System.currentTimeMillis();
        long nbTest = 2L;
        int size = 0x6400000;
        int i = 0;
        while ((long)i < nbTest) {
            File f = File.createTempFile("benchmark", ".raw");
            FileOutputStream fOp = new FileOutputStream(f);
            byte[] b = new byte[0x6400000];
            fOp.write(b);
            fOp.flush();
            fOp.close();
            f.delete();
            ++i;
        }
        long t1 = System.currentTimeMillis();
        long time = t1 - t0;
        long s = nbTest * 0x6400000L;
        double speed = s / time;
        String result = String.valueOf(Math.round(speed / 1000.0)) + " MB/s";
        return result;
    }
}

