/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class GraphReader<V, E>
implements GraphGenerator<V, E, V> {
    private final BufferedReader _in;

    public GraphReader(String file) throws IOException {
        this._in = new BufferedReader(new FileReader(file));
    }

    private List<String> split(String src) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(src);
        while (tok.hasMoreTokens()) {
            l.add(tok.nextToken());
        }
        return l;
    }

    private List<String> skipComments() {
        try {
            if (this._in.ready()) {
                List<String> cols = this.split(this._in.readLine());
                while (cols.isEmpty() || cols.get(0).equals("c") || cols.get(0).startsWith("%")) {
                    cols = this.split(this._in.readLine());
                }
                return cols;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private int readNodeCount() {
        List<String> cols = this.skipComments();
        if (cols.get(0).equals("p")) {
            return Integer.parseInt(cols.get(1));
        }
        return -1;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        int size = this.readNodeCount();
        if (resultMap == null) {
            resultMap = new HashMap<String, V>();
        }
        int i = 0;
        while (i < size) {
            V newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            resultMap.put(Integer.toString(i + 1), newVertex);
            ++i;
        }
        List<String> cols = this.skipComments();
        while (cols != null) {
            if (cols.get(0).equals("e")) {
                target.addEdge(resultMap.get(cols.get(1)), resultMap.get(cols.get(2)));
            }
            cols = this.skipComments();
        }
    }

    public static void main(String[] args) throws Exception {
        GraphReader<Integer, DefaultEdge> reader = new GraphReader<Integer, DefaultEdge>(args[0]);
        SimpleGraph g = new SimpleGraph(DefaultEdge.class);
        IntVertexFactory vf = new IntVertexFactory();
        reader.generateGraph((Graph<Integer, DefaultEdge>)g, (VertexFactory<Integer>)vf, (Map<String, Integer>)null);
        System.out.println(g);
    }

    private static final class IntVertexFactory
    implements VertexFactory<Integer> {
        int last = 0;

        private IntVertexFactory() {
        }

        @Override
        public Integer createVertex() {
            return this.last++;
        }
    }
}

