/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml.persistence;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.xml.persistence.BaseXMLIO;
import org.openconcerto.xml.persistence.Persistent;

public class XMLIO
extends BaseXMLIO {
    public XMLIO(File dir) {
        super(dir);
    }

    private final File getFile(Persistent pers, String id) {
        return new File(this.getDir(pers.getClass()), String.valueOf(pers.getLabel()) + "_" + id + ".xml");
    }

    private final String getID(File f) {
        if (!f.getName().endsWith(".xml")) {
            throw new IllegalArgumentException(f + " was not saved with " + this);
        }
        int underscore = f.getName().lastIndexOf(95);
        return f.getName().substring(underscore + 1, f.getName().length() - ".xml".length());
    }

    private final File searchFile(Class<?> clazz, final String id) {
        File dir = this.getDir(clazz);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return name.endsWith("_" + id + ".xml");
            }
        });
        if (files.length > 1) {
            throw new IllegalStateException("id " + id + " is not unique");
        }
        return files.length == 0 ? null : files[0];
    }

    private final File[] searchFiles(Class<?> clazz) {
        File dir = this.getDir(clazz);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return name.endsWith(".xml");
            }
        });
        return files;
    }

    @Override
    public void save(Object ser, Persistent pers, String id) throws IOException {
        this.delete(pers.getClass(), id);
        File f = this.getFile(pers, id);
        File dir = f.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("cannot create directory " + dir);
        }
        FileWriter fw = new FileWriter(f);
        writer.output(new Document((Element)ser), (Writer)fw);
        fw.close();
    }

    private static Element load(File f) throws IOException, JDOMException {
        Document doc = new SAXBuilder().build(f);
        return doc.getRootElement();
    }

    @Override
    public Object load(Class<?> clazz, String id) throws IOException {
        try {
            return XMLIO.load(this.searchFile(clazz, id));
        }
        catch (JDOMException e) {
            throw ExceptionUtils.createExn(IOException.class, "", e);
        }
    }

    @Override
    public void delete(Class<?> clazz, String id) {
        File file = this.searchFile(clazz, id);
        if (file != null) {
            file.delete();
        }
    }

    @Override
    public void delete(Class<?> clazz) throws IOException {
        FileUtils.rm_R(this.getDir(clazz));
    }

    @Override
    public boolean exists(Class<?> clazz, String id) {
        return this.searchFile(clazz, id) != null;
    }

    @Override
    protected void beginAutoCommit() throws IOException {
    }

    @Override
    public void unload() {
    }

    @Override
    public Set<String> getIDs(Class<?> clazz) throws IOException {
        File[] files = this.searchFiles(clazz);
        HashSet<String> result = new HashSet<String>(files.length);
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            result.add(this.getID(file));
            ++i;
        }
        return result;
    }
}

