/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml.persistence;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.ElementFilter;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.xml.persistence.BaseXMLIO;
import org.openconcerto.xml.persistence.Persistent;

public class SingleXMLIO
extends BaseXMLIO {
    private static final Document EMPTY_DOC = new Document(new Element("root"));
    private final Map<File, Document> docs = new HashMap<File, Document>();
    private final Set<Class<?>> unsync = new HashSet();
    private SAXBuilder builder;

    private static void saveDoc(Document doc, File file) throws IOException {
        FileUtils.mkdir_p(file.getParentFile());
        FileWriter fw = new FileWriter(file);
        writer.output(doc, (Writer)fw);
        fw.close();
    }

    public SingleXMLIO(File dir) {
        super(dir);
        this.resetBuilder();
    }

    private final File getFile(Class<?> clazz) {
        return new File(this.getDir(clazz), "_single.xml");
    }

    private final Document getDocument(Class<?> clazz) throws IOException {
        return this.getDocument(clazz, false);
    }

    private final Document getDocument(Class<?> clazz, boolean create) throws IOException {
        File file = this.getFile(clazz);
        Document doc = this.docs.get(file);
        if (doc == null) {
            if (file.exists()) {
                try {
                    doc = this.getBuilder().build(file);
                }
                catch (JDOMException e) {
                    throw ExceptionUtils.createExn(IOException.class, "", e);
                }
            } else if (create) {
                doc = EMPTY_DOC.clone();
                SingleXMLIO.saveDoc(doc, file);
            }
            if (doc != null) {
                this.docs.put(file, doc);
            }
        }
        return doc;
    }

    private final Element getElement(Class<?> clazz, final String id) throws IOException {
        Document doc = this.getDocument(clazz);
        if (doc == null) {
            return null;
        }
        ArrayList<Element> elems = new ArrayList<Element>(doc.getRootElement().getContent(new ElementFilter(){

            @Override
            public Element filter(Object obj) {
                Element elem = super.filter(obj);
                return elem != null && SingleXMLIO.this.getID(elem).equals(id) ? elem : null;
            }
        }));
        if (elems.size() > 1) {
            throw new IllegalStateException("id " + id + " not unique");
        }
        return elems.size() == 0 ? null : (Element)elems.get(0);
    }

    private final Element getElement(Persistent pers, String id) throws IOException {
        return this.getElement(pers.getClass(), id);
    }

    private final String getID(Element elem) {
        return elem.getAttributeValue("id", NS);
    }

    @Override
    public synchronized void save(Object ser, Persistent pers, String id) throws IOException {
        Document doc;
        Element oldElem = this.getElement(pers, id);
        if (oldElem == null) {
            doc = this.getDocument(pers.getClass(), true);
        } else {
            doc = oldElem.getDocument();
            oldElem.detach();
        }
        Element newElem = (Element)ser;
        newElem.setAttribute("id", id, NS);
        if (pers.getLabel() != null) {
            newElem.setAttribute("label", pers.getLabel(), NS);
        }
        doc.getRootElement().addContent(newElem);
        this.save(pers.getClass());
    }

    private synchronized void save(Class<?> clazz) throws IOException {
        if (this.isAutoCommit()) {
            SingleXMLIO.saveDoc(this.getDocument(clazz, true), this.getFile(clazz));
        } else {
            this.unsync.add(clazz);
        }
    }

    @Override
    protected void beginAutoCommit() throws IOException {
        Iterator<Class<?>> iter = this.unsync.iterator();
        while (iter.hasNext()) {
            Class<?> clazz = iter.next();
            this.save(clazz);
            iter.remove();
        }
    }

    @Override
    public void delete(Class<?> clazz, String id) throws IOException {
        if (this.exists(clazz, id)) {
            this.getElement(clazz, id).detach();
            this.save(clazz);
        }
    }

    @Override
    public synchronized void delete(Class<?> clazz) throws IOException {
        if (this.getDocument(clazz) != null) {
            this.docs.put(this.getFile(clazz), EMPTY_DOC.clone());
            this.save(clazz);
        }
    }

    @Override
    public Object load(Class<?> clazz, String id) throws IOException {
        return this.getElement(clazz, id);
    }

    @Override
    public synchronized void unload() {
        if (this.unsync.size() > 0) {
            throw new IllegalStateException();
        }
        this.docs.clear();
        this.resetBuilder();
    }

    @Override
    public boolean exists(Class<?> clazz, String id) {
        try {
            return this.getElement(clazz, id) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Set<String> getIDs(Class<?> clazz) throws IOException {
        HashSet<String> res = new HashSet<String>();
        Document doc = this.getDocument(clazz);
        if (doc == null) {
            return Collections.emptySet();
        }
        for (Element elem : doc.getRootElement().getChildren()) {
            res.add(this.getID(elem));
        }
        return res;
    }

    private final void resetBuilder() {
        this.builder = null;
    }

    private final SAXBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new SAXBuilder();
        }
        return this.builder;
    }
}

