/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.IPredicate;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class JDOMUtils {
    public static final XMLOutputter OUTPUTTER;
    private static final SAXBuilder BUILDER;

    static {
        Format rawFormat = Format.getRawFormat();
        rawFormat.setLineSeparator("\n");
        OUTPUTTER = new XMLOutputter(rawFormat);
        BUILDER = JDOMUtils.createBuilder();
    }

    public static final SAXBuilder createBuilder() {
        SAXBuilder res = new SAXBuilder();
        res.setValidation(false);
        return res;
    }

    public static Element parseElementString(String xml, Namespace[] namespaces) throws JDOMException {
        return (Element)JDOMUtils.parseString(xml.trim(), namespaces).get(0);
    }

    public static List parseString(String xml, Namespace[] namespaces) throws JDOMException {
        String dummy = "<dummy";
        int i = 0;
        while (i < namespaces.length) {
            Namespace ns = namespaces[i];
            dummy = String.valueOf(dummy) + " xmlns:" + ns.getPrefix() + "=\"" + ns.getURI() + "\"";
            ++i;
        }
        xml = String.valueOf(dummy) + ">" + xml + "</dummy>";
        return JDOMUtils.parseStringDocument(xml).getRootElement().removeContent();
    }

    public static Element parseString(String xml) throws JDOMException {
        return JDOMUtils.parseElementString(xml, new Namespace[0]);
    }

    public static synchronized Document parseStringDocument(String xml) throws JDOMException {
        return JDOMUtils.parseStringDocument(xml, BUILDER);
    }

    public static Document parseStringDocument(String xml, SAXBuilder builder) throws JDOMException {
        Document doc = null;
        try {
            doc = builder.build(new StringReader(xml));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static String output(Element xml) {
        return OUTPUTTER.outputString(xml);
    }

    public static String output(Document xml) {
        return OUTPUTTER.outputString(xml);
    }

    public static Element getAncestor(Element element, final String name, final Namespace ns) {
        return JDOMUtils.getAncestor(element, new IPredicate<Element>(){

            @Override
            public boolean evaluateChecked(Element elem) {
                return elem.getName().equals(name) && elem.getNamespace().equals(ns);
            }
        });
    }

    public static Element getAncestor(Element element, IPredicate<Element> pred) {
        Element current = element;
        while (current != null) {
            if (pred.evaluateChecked(current)) {
                return current;
            }
            current = current.getParentElement();
        }
        return null;
    }

    public static void addNamespaces(Element elem, Collection<Namespace> c) {
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int stop = c.size() - 1;
            int i = 0;
            while (i < stop) {
                Namespace ns = (Namespace)list.get(i);
                if (elem.getNamespace(ns.getPrefix()) == null) {
                    elem.addNamespaceDeclaration(ns);
                }
                ++i;
            }
        } else {
            for (Namespace ns : c) {
                if (elem.getNamespace(ns.getPrefix()) != null) continue;
                elem.addNamespaceDeclaration(ns);
            }
        }
    }

    public static void addNamespaces(Element elem, Namespace ... l) {
        Namespace[] namespaceArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Namespace ns = namespaceArray[n2];
            if (elem.getNamespace(ns.getPrefix()) == null) {
                elem.addNamespaceDeclaration(ns);
            }
            ++n2;
        }
    }

    public static Element detachEmptyParent(Element elem) {
        Element parent = elem.getParentElement();
        elem.detach();
        if (parent != null && parent.getChildren().isEmpty()) {
            parent.detach();
        }
        return parent;
    }

    public static Element getOrCreateChild(Element parent, String name, Namespace ns) {
        return JDOMUtils.getOrCreateChild(parent, name, ns, -1);
    }

    public static Element getOrCreateChild(Element parent, String name, Namespace ns, int index) {
        Element res = parent.getChild(name, ns);
        if (res == null) {
            res = new Element(name, ns);
            if (index < 0) {
                parent.addContent(res);
            } else {
                parent.addContent(index, res);
            }
        }
        assert (res.getParent() == parent);
        return res;
    }

    public Element mkElem(Element current, String path) {
        String[] items = path.split("/");
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            String[] qname = item.split(":");
            Element elem = qname.length == 1 ? new Element(item) : new Element(qname[1], current.getNamespace(qname[0]));
            current.addContent(elem);
            current = elem;
            ++i;
        }
        return current;
    }

    public static void insertAfter(Element insertAfter, Collection<? extends Content> toAdd) {
        JDOMUtils.insertSiblings(insertAfter, toAdd, true);
    }

    public static void insertBefore(Element insertBefore, Collection<? extends Content> toAdd) {
        JDOMUtils.insertSiblings(insertBefore, toAdd, false);
    }

    public static void insertSiblings(Element sibling, Collection<? extends Content> toAdd, boolean after) {
        Element parentElement = sibling.getParentElement();
        int index = parentElement.indexOf(sibling);
        parentElement.addContent(after ? index + 1 : index, toAdd);
    }

    public static boolean equals(Element elem1, Element elem2) {
        if (elem1 == elem2 || elem1 == null && elem2 == null) {
            return true;
        }
        if (elem1 == null || elem2 == null) {
            return false;
        }
        return elem1.getName().equals(elem2.getName()) && elem1.getNamespace().equals(elem2.getNamespace());
    }

    public static boolean equalsDeep(Element elem1, Element elem2) {
        return JDOMUtils.equalsDeep(elem1, elem2, true);
    }

    public static boolean equalsDeep(Element elem1, Element elem2, boolean normalizeText) {
        return JDOMUtils.getDiff(elem1, elem2, normalizeText) == null;
    }

    static String getDiff(Element elem1, Element elem2, boolean normalizeText) {
        if (elem1 == elem2) {
            return null;
        }
        if (!JDOMUtils.equals(elem1, elem2)) {
            return "element name or namespace";
        }
        List attr1 = elem1.getAttributes();
        List attr2 = elem2.getAttributes();
        if (attr1.size() != attr2.size()) {
            return "attributes count";
        }
        for (Attribute attr : attr1) {
            if (attr.getValue().equals(elem2.getAttributeValue(attr.getName(), attr.getNamespace()))) continue;
            return "attribute value";
        }
        IPredicate<Content> filter = new IPredicate<Content>(){

            @Override
            public boolean evaluateChecked(Content input) {
                return input instanceof Text || input instanceof Element;
            }
        };
        Iterator<Content> contents1 = JDOMUtils.getContent(elem1, (IPredicate<? super Content>)filter, true);
        Iterator<Content> contents2 = JDOMUtils.getContent(elem2, (IPredicate<? super Content>)filter, true);
        while (contents1.hasNext() && contents2.hasNext()) {
            Content content1 = contents1.next();
            Content content2 = contents2.next();
            if (content1.getClass() != content2.getClass()) {
                return "content";
            }
            if (content1 instanceof Text) {
                String s2;
                String s1 = normalizeText ? ((Text)content1).getTextNormalize() : content1.getValue();
                String string = s2 = normalizeText ? ((Text)content2).getTextNormalize() : content2.getValue();
                if (s1.equals(s2)) continue;
                return "text";
            }
            String rec = JDOMUtils.getDiff((Element)content1, (Element)content2, normalizeText);
            if (rec == null) continue;
            return rec;
        }
        if (contents1.hasNext() || contents2.hasNext()) {
            return "content size";
        }
        return null;
    }

    public static Iterator<Content> getContent(Element elem, final IPredicate<? super Content> pred, boolean mergeText) {
        final Iterator<Content> iter = elem.getContent(new Filter(){

            @Override
            public boolean matches(Object obj) {
                return pred.evaluateChecked((Content)obj);
            }
        }).iterator();
        if (!mergeText) {
            return iter;
        }
        return new Iterator<Content>(){
            private Content next = null;

            @Override
            public boolean hasNext() {
                return this.next != null || iter.hasNext();
            }

            @Override
            public Content next() {
                if (this.next != null) {
                    Content res = this.next;
                    this.next = null;
                    return res;
                }
                Content res = (Content)iter.next();
                if (!$assertionsDisabled && res == null) {
                    throw new AssertionError();
                }
                if (res instanceof Text && iter.hasNext()) {
                    this.next = (Content)iter.next();
                    Text concatText = null;
                    while (this.next instanceof Text) {
                        if (concatText == null) {
                            concatText = new Text(res.getValue());
                        }
                        concatText.append((Text)this.next);
                        Content content = this.next = iter.hasNext() ? (Content)iter.next() : null;
                    }
                    if (!$assertionsDisabled && this.next == null) {
                        throw new AssertionError();
                    }
                    if (concatText != null) {
                        res = concatText;
                    }
                }
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static final Namespace getNamespace(Object input) {
        Namespace res = input instanceof Element ? ((Element)input).getNamespace() : (input instanceof Attribute ? ((Attribute)input).getNamespace() : null);
        return res;
    }

    static SAXException validate(Document doc, Schema schema, ErrorHandler errorHandler) {
        return JDOMUtils.validate(JDOMUtils.output(doc), schema, errorHandler);
    }

    static SAXException validate(String doc, Schema schema, ErrorHandler errorHandler) {
        ByteArrayInputStream ins = new ByteArrayInputStream(doc.getBytes(StringUtils.UTF8));
        Validator validator = schema.newValidator();
        if (errorHandler != null) {
            validator.setErrorHandler(errorHandler);
        }
        try {
            validator.validate(new StreamSource(ins));
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read the document", e);
        }
        catch (SAXException e) {
            return e;
        }
    }

    static void validateDTD(Document doc, SAXBuilder b, ErrorHandler errorHandler) throws JDOMException {
        JDOMUtils.validateDTD(JDOMUtils.output(doc), b, errorHandler);
    }

    static void validateDTD(String doc, SAXBuilder b, ErrorHandler errorHandler) throws JDOMException {
        ErrorHandler origEH = b.getErrorHandler();
        boolean origValidation = b.getValidation();
        try {
            b.setErrorHandler(errorHandler);
            b.setValidation(true);
            JDOMUtils.parseStringDocument(doc, b);
        }
        finally {
            b.setErrorHandler(origEH);
            b.setValidation(origValidation);
        }
    }
}

