/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.doml;

import java.io.IOException;
import java.io.Reader;

public class PushBackReader
extends Reader {
    protected Reader in;
    private char[] buf;
    private int pos;

    public PushBackReader(Reader in, int size) {
        this.in = in;
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new char[size];
        this.pos = size;
    }

    public PushBackReader(Reader in) {
        this(in, 1);
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++];
        }
        return this.in.read();
    }

    public void unread(int c) throws IOException {
        this.buf[--this.pos] = (char)c;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.buf = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new IOException("read not supported");
    }
}

