/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.io.File;
import java.io.IOException;
import org.openconcerto.ui.preferences.AbstractProps;
import org.openconcerto.utils.FileUtils;

public class EmailProps
extends AbstractProps {
    public static final int DEFAULT = 0;
    public static final int THUNDERBIRD = 1;
    public static final int OUTLOOK = 2;
    protected static EmailProps instance;
    private String propsFileName = null;
    private static String DEFAULT_FILE;
    private String defaultPropsFileName = DEFAULT_FILE;

    static {
        DEFAULT_FILE = "./Configuration/Email.properties";
    }

    public static synchronized EmailProps getInstance() {
        if (instance == null) {
            instance = new EmailProps();
        }
        return instance;
    }

    @Override
    protected String getPropsFileName() {
        if (this.propsFileName == null) {
            return this.getDefaultPropsFileName();
        }
        return this.propsFileName;
    }

    public void setDefaultPropsFileName(String defaultPropsFileName) {
        this.defaultPropsFileName = defaultPropsFileName;
    }

    protected String getDefaultPropsFileName() {
        if (this.defaultPropsFileName == null) {
            return DEFAULT_FILE;
        }
        return this.defaultPropsFileName;
    }

    public void setPropsFileName(String propsFileName) {
        this.propsFileName = propsFileName;
        File file = new File(this.getPropsFileName());
        File fileDefault = new File(this.getDefaultPropsFileName());
        if (!file.exists() && fileDefault.exists()) {
            try {
                FileUtils.copyFile(fileDefault, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.load();
    }

    public String getThunderbirdPath() {
        String stringProperty = this.getStringProperty("thunderbird.path");
        if (stringProperty.trim().length() == 0) {
            return "C:\\Program Files\\Mozilla Thunderbird\\thunderbird.exe";
        }
        return stringProperty;
    }

    public void setThunderbirdPath(String text) {
        this.setProperty("thunderbird.path", text);
    }

    public int getMode() {
        return this.getIntProperty("mode", 0);
    }

    public void setMode(int mode) {
        this.setProperty("mode", String.valueOf(mode));
    }

    public void setTitle(String text) {
        this.setProperty("title", String.valueOf(text));
    }

    public String getFrom() {
        return this.getStringProperty("from");
    }

    public void setFrom(String from) {
        this.setProperty("from", String.valueOf(from));
    }

    public String getTitle() {
        return this.getStringProperty("title");
    }

    public void setHeader(String text) {
        this.setProperty("header", String.valueOf(text));
    }

    public String getHeader() {
        return this.getStringProperty("header");
    }

    public void setFooter(String text) {
        this.setProperty("footer", String.valueOf(text));
    }

    public void setEncodingCharsetName(String charset) {
        this.setProperty("encoding", charset);
    }

    public String getFooter() {
        return this.getStringProperty("footer");
    }

    public String getEncodingCharsetName() {
        String charset = "UTF-8";
        String tmp = this.getStringProperty("encoding");
        if (tmp.trim().length() > 0) {
            charset = tmp;
        }
        return charset;
    }
}

